/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.serializing.serializers;

import com.jme3.network.serializing.Serializer;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArraySerializer
extends Serializer {
    private int[] getDimensions(Object array) {
        int depth = 0;
        for (Class<?> nextClass = array.getClass().getComponentType(); nextClass != null; nextClass = nextClass.getComponentType()) {
            ++depth;
        }
        int[] dimensions = new int[depth];
        dimensions[0] = Array.getLength(array);
        if (depth > 1) {
            this.collectDimensions(array, 1, dimensions);
        }
        return dimensions;
    }

    private void collectDimensions(Object array, int dimension, int[] dimensions) {
        boolean elementsAreArrays = dimension < dimensions.length - 1;
        int s = Array.getLength(array);
        for (int i = 0; i < s; ++i) {
            Object element = Array.get(array, i);
            if (element == null) continue;
            dimensions[dimension] = Math.max(dimensions[dimension], Array.getLength(element));
            if (!elementsAreArrays) continue;
            this.collectDimensions(element, dimension + 1, dimensions);
        }
    }

    @Override
    public <T> T readObject(ByteBuffer data, Class<T> c) throws IOException {
        int dimensionCount = data.get();
        if (dimensionCount == 0) {
            return null;
        }
        int[] dimensions = new int[dimensionCount];
        for (int i = 0; i < dimensionCount; ++i) {
            dimensions[i] = data.getInt();
        }
        Serializer elementSerializer = null;
        Class<Object> elementClass = c;
        while (elementClass.getComponentType() != null) {
            elementClass = elementClass.getComponentType();
        }
        if (Modifier.isFinal(elementClass.getModifiers())) {
            elementSerializer = Serializer.getSerializer(elementClass);
        }
        Object array = Array.newInstance(elementClass, dimensions);
        this.readArray(elementSerializer, elementClass, data, array, 0, dimensions);
        return (T)array;
    }

    @Override
    public void writeObject(ByteBuffer buffer, Object object) throws IOException {
        if (object == null) {
            buffer.put((byte)0);
            return;
        }
        int[] dimensions = this.getDimensions(object);
        buffer.put((byte)dimensions.length);
        for (int dimension : dimensions) {
            buffer.putInt(dimension);
        }
        Serializer elementSerializer = null;
        Class<?> elementClass = object.getClass();
        while (elementClass.getComponentType() != null) {
            elementClass = elementClass.getComponentType();
        }
        if (Modifier.isFinal(elementClass.getModifiers())) {
            elementSerializer = Serializer.getSerializer(elementClass);
        }
        this.writeArray(elementSerializer, buffer, object, 0, dimensions.length);
    }

    private void writeArray(Serializer elementSerializer, ByteBuffer buffer, Object array, int dimension, int dimensionCount) throws IOException {
        int length = Array.getLength(array);
        if (dimension > 0) {
            buffer.putInt(length);
        }
        boolean elementsAreArrays = dimension < dimensionCount - 1;
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(array, i);
            if (elementsAreArrays) {
                if (element == null) continue;
                this.writeArray(elementSerializer, buffer, element, dimension + 1, dimensionCount);
                continue;
            }
            if (elementSerializer != null) {
                elementSerializer.writeObject(buffer, element);
                continue;
            }
            Serializer.writeClassAndObject(buffer, element);
        }
    }

    private void readArray(Serializer elementSerializer, Class elementClass, ByteBuffer buffer, Object array, int dimension, int[] dimensions) throws IOException {
        boolean elementsAreArrays = dimension < dimensions.length - 1;
        int length = dimension == 0 ? dimensions[0] : buffer.getInt();
        for (int i = 0; i < length; ++i) {
            if (elementsAreArrays) {
                Object element = Array.get(array, i);
                if (element == null) continue;
                this.readArray(elementSerializer, elementClass, buffer, element, dimension + 1, dimensions);
                continue;
            }
            if (elementSerializer != null) {
                Array.set(array, i, elementSerializer.readObject(buffer, elementClass));
                continue;
            }
            Array.set(array, i, Serializer.readClassAndObject(buffer));
        }
    }
}

