/*
 * Decompiled with CFR 0.152.
 */
package mygame;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import mygame.ColliderHelper;
import mygame.GameObj;

public class Shots {
    Node rootNode;
    Map<String, Set<Shot>> used = new HashMap<String, Set<Shot>>();
    Map<String, ArrayList<Shot>> unused = new HashMap<String, ArrayList<Shot>>();
    Map<String, float[]> shotConf = new HashMap<String, float[]>();

    public Shots(Node rootNode) {
        this.rootNode = rootNode;
    }

    public Shot getShoot(String type) {
        ArrayList<Shot> l = this.unused.get(type);
        if (l.size() > 0) {
            Shot s = l.remove(l.size() - 1);
            this.used.get(type).add(s);
            return s;
        }
        return null;
    }

    public void unuse(String type, Shot s) {
        this.unused.get(type).add(s);
    }

    public void update(float tpf, float zCorr, ColliderHelper collider, String collGroup) {
        for (Map.Entry<String, Set<Shot>> ent : this.used.entrySet()) {
            Iterator<Shot> it = ent.getValue().iterator();
            while (it.hasNext()) {
                Shot s = it.next();
                s.life -= tpf;
                if (s.life <= 0.0f) {
                    it.remove();
                    this.unuse(ent.getKey(), s);
                    this.rootNode.detachChild(s);
                    continue;
                }
                s.move(s.dir.x * tpf, 0.0f, (s.dir.z + zCorr) * tpf);
                s.rotate(s.rot);
                collider.add(collGroup, s);
            }
        }
    }

    public void shoot(String type, String conf, float x, float z) {
        Shot s = this.getShoot(type);
        if (s != null) {
            s.conf = this.shotConf.get(conf);
            s.dir.x = s.conf[2] * s.speed;
            s.dir.z = s.conf[3] * s.speed;
            s.life = s.clife;
            s.setLocalTranslation(x + s.conf[0], 0.0f, z + s.conf[1]);
            this.rootNode.attachChild(s);
        }
    }

    public void addConf(String conf, float ofx, float ofz, float dx, float dz) {
        this.shotConf.put(conf, new float[]{ofx, ofz, dx, dz});
    }

    public Shot addShot(String type, float speed, float life) {
        return this.addShot(type, speed, life, Quaternion.ZERO);
    }

    public Shot addShot(String type, float speed, float life, Quaternion rot) {
        Shot s = new Shot();
        s.clife = life;
        s.speed = speed;
        s.rot = rot;
        if (this.unused.get(type) == null) {
            this.used.put(type, new HashSet());
            this.unused.put(type, new ArrayList());
        }
        this.unuse(type, s);
        return s;
    }

    class Shot
    extends GameObj {
        Vector3f dir = new Vector3f(0.0f, 0.0f, 0.0f);
        Spatial mesh;
        float clife;
        Quaternion rot;
        float[] conf;

        Shot() {
            this.dieTime = 0.0f;
            this.damage = 1.0f;
        }
    }
}

