/*
 * Decompiled with CFR 0.152.
 */
package mygame;

import com.jme3.app.SimpleApplication;
import com.jme3.font.BitmapFont;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.light.PointLight;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.filters.BloomFilter;
import com.jme3.post.filters.DepthOfFieldFilter;
import com.jme3.post.filters.FXAAFilter;
import com.jme3.post.ssao.SSAOFilter;
import com.jme3.renderer.RenderManager;
import java.util.Iterator;
import java.util.logging.Logger;
import mygame.AudioGirl;
import mygame.ColliderHelper;
import mygame.Game;
import mygame.GameObj;
import mygame.Hud;
import mygame.Level;
import mygame.LevelEvent;
import mygame.LevelGenerator;
import mygame.LevelParser;
import mygame.LevelTiming;
import mygame.Menu;
import mygame.Powerup;
import mygame.Shots;
import mygame.Timing;

public class Main
extends SimpleApplication
implements ActionListener {
    AudioGirl audioGirl = new AudioGirl();
    String reqGameState = "";
    String curGameState = "";
    float loadWaitTimer = 0.0f;
    float shipAccel = 10.0f;
    float shipAccelDamp = 0.1f;
    float fmaxAccel = 3.0f;
    float fmaxSpeed = 3.0f;
    Vector3f pOffset = new Vector3f(0.0f, 0.0f, 0.0f);
    Vector3f pSpeed = new Vector3f(0.0f, 0.0f, 0.0f);
    Vector3f pAccel = new Vector3f(0.0f, 0.0f, 0.0f);
    Vector3f maxAccel = new Vector3f(this.fmaxAccel, 0.0f, this.fmaxAccel);
    Vector3f minAccel = new Vector3f(-this.fmaxAccel, 0.0f, -this.fmaxAccel);
    Vector3f maxSpeed = new Vector3f(this.fmaxSpeed, 0.0f, this.fmaxSpeed);
    Vector3f minSpeed = new Vector3f(-this.fmaxSpeed, 0.0f, -this.fmaxSpeed);
    Vector3f maxOffset = new Vector3f(2.2f, 0.0f, 6.0f);
    Vector3f minOffset = new Vector3f(-2.2f, 0.0f, 0.0f);
    float directionRot = 0.0f;
    float introTime = 0.0f;
    float outroTime = 0.0f;
    float introPhase = 0.0f;
    float introLength = 4.0f;
    LevelTiming playerCam = new LevelTiming();
    Level level;
    Shots shots;
    PointLight light;
    Vector3f lightPos = new Vector3f(0.0f, 10.0f, 0.0f);
    ColliderHelper collider = new ColliderHelper("ship", "shot", "enemy", "eshot", "powerup");
    float warpFact;
    ColorRGBA warpColor;
    Hud hud;
    Menu menu;
    float accelX = 0.0f;
    float accelZ = 0.0f;
    float dampX = 0.6f;
    float dampZ = 0.6f;
    boolean shoot = false;
    float healthUpgrade = 0.0f;
    int curLevel = 1;
    int lastLevel = 3;
    LevelGenerator gen;
    float time = 0.0f;
    float speed = 1.0f;
    Boolean lightAdded = false;
    boolean looseFlag = false;
    boolean winFlag = false;

    public static void main(String[] args) {
        Logger.getLogger("").setLevel(java.util.logging.Level.WARNING);
        Main app = new Main();
        app.start();
    }

    public void initLevel() {
        String name = "level" + this.curLevel + ".txt";
        this.level = LevelParser.loadLevel(name, this.gen);
        this.time = 0.0f;
        this.playerCam = this.level.player;
        this.shots = new Shots(this.rootNode);
        this.gen.createShots(this.shots);
        this.pOffset = new Vector3f(0.0f, 0.0f, 0.0f);
        if (!this.lightAdded.booleanValue()) {
            this.light = new PointLight();
            this.light.setPosition(this.lightPos);
            this.light.setColor(ColorRGBA.White);
            this.rootNode.addLight(this.light);
            this.lightAdded = true;
        }
        this.cam.setLocation(new Vector3f(0.0f, 5.0f, 0.0f));
        this.cam.lookAt(new Vector3f(0.0f, 0.0f, 3.5f), new Vector3f(0.0f, 0.0f, 1.0f));
        this.introTime = 0.0f;
        this.introPhase = 0.0f;
        this.looseFlag = false;
        this.winFlag = false;
        this.warpFact = 0.0f;
        this.warpColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void cleanupLevel() {
        this.rootNode.detachAllChildren();
    }

    public void gotoGame() {
        this.reqGameState = "gamestart";
        this.hud.setFade(0.0f, 1.0f);
    }

    public BitmapFont getFont() {
        return this.guiFont;
    }

    public void simpleInitApp() {
        FilterPostProcessor fpp = new FilterPostProcessor(this.assetManager);
        SSAOFilter ssaoFilter = new SSAOFilter(5.1f, 1.2f, 0.2f, 0.1f);
        BloomFilter bloomFilter = new BloomFilter(BloomFilter.GlowMode.Scene);
        DepthOfFieldFilter dofFilter = new DepthOfFieldFilter();
        FXAAFilter fxaaFilter = new FXAAFilter();
        bloomFilter.setBloomIntensity(0.4f);
        dofFilter.setFocusDistance(5.0f);
        dofFilter.setFocusRange(50.0f);
        dofFilter.setBlurScale(1.0f);
        fpp.addFilter((Filter)fxaaFilter);
        fpp.addFilter((Filter)dofFilter);
        fpp.addFilter((Filter)bloomFilter);
        this.viewPort.addProcessor(fpp);
        this.gen = new LevelGenerator(this.assetManager, this.rootNode);
        this.gen.initAssets();
        this.guiFont = this.assetManager.loadFont("Interface/Fonts/AmericanCaptain.fnt");
        this.inputManager.addMapping("SHOOT", new KeyTrigger(57));
        this.inputManager.addMapping("FW", new KeyTrigger(200));
        this.inputManager.addMapping("BW", new KeyTrigger(208));
        this.inputManager.addMapping("LT", new KeyTrigger(203));
        this.inputManager.addMapping("RT", new KeyTrigger(205));
        this.inputManager.addMapping("SPACE", new KeyTrigger(28));
        Game game = new Game();
        game.initialize(this.stateManager, this);
        this.stateManager.attach(game);
        this.stateManager.getState(Game.class).setEnabled(false);
        this.menu = new Menu();
        this.menu.initialize(this.stateManager, this);
        this.stateManager.attach(this.menu);
        this.stateManager.getState(Menu.class).setEnabled(true);
        this.hud = new Hud();
        this.hud.initialize(this.stateManager, this);
        this.stateManager.attach(this.hud);
        this.stateManager.getState(Hud.class).setEnabled(true);
        this.setDisplayFps(false);
        this.setDisplayStatView(false);
        this.audioGirl.Init(this);
        this.audioGirl.AttachNodes();
        this.hud.setFade(1.0f, 1.0f);
        this.reqGameState = "startup";
        this.inputManager.addListener(this, "SPACE", "FW", "BW", "LT", "RT", "SHOOT");
    }

    void updateEnemies(float tpf, float zcorr) {
        this.level.enemies.update(this.time, tpf, this.rootNode);
        for (Timing t : this.level.enemies.active) {
            Vector3f pos = t.path.getPosition(this.time - t.start, t.obj.speed);
            pos = pos.add(t.offset);
            pos.z += zcorr;
            t.obj.updatePos(pos, tpf);
            this.collider.add("enemy", t.obj);
            t.obj.updateRot(new Vector3f((float)Math.sin(this.time * 0.4f - t.start) * 0.25f, this.time, (float)Math.cos(this.time * 0.55f - t.start) * 0.15f), tpf);
        }
    }

    void updatePowerups(float tpf, float zcorr) {
        this.level.powerups.update(this.time, tpf, this.rootNode);
        for (Timing t : this.level.powerups.active) {
            Vector3f pos = t.path.getPosition(this.time - t.start, t.obj.speed);
            pos = pos.add(t.offset);
            pos.z += zcorr;
            t.obj.updatePos(pos, tpf);
            this.collider.add("powerup", t.obj);
            t.obj.updateRot(new Vector3f((float)Math.sin(this.time * 0.4f - t.start) * 0.25f, this.time, (float)Math.cos(this.time * 0.55f - t.start) * 0.15f), tpf);
        }
    }

    public void collide() {
        GameObj e;
        this.collider.collide("shot", "enemy");
        Iterator<GameObj> esIt = this.collider.get("enemy").iterator();
        for (GameObj s : this.collider.get("shot")) {
            e = esIt.next();
            if (!e.isDying()) {
                this.level.score += e.score;
                this.level.warp = Math.min(e.singFill + this.level.warp, 1.0f);
            }
            s.life = 0.0f;
            e.life -= ((Shots.Shot)s).damage;
            if (e.isBoss()) {
                this.level.bossHealth = e.life;
                this.audioGirl.hitEnemyB();
            } else {
                this.audioGirl.hitEnemyA();
            }
            if (!(e.life <= 0.0f)) continue;
            e.die();
        }
        this.collider.collide("ship", "powerup");
        for (GameObj o : this.collider.get("powerup")) {
            Powerup p = (Powerup)o;
            if (!p.isDying()) {
                this.level.score += p.score;
            }
            p.die();
            if (p.ptype == 3) {
                this.audioGirl.weaponUpgrade();
                this.level.addWeapon("rocketr", "diagr");
                this.level.addWeapon("rocketl", "diagl");
                this.shoot = false;
            }
            if (p.ptype == 2) {
                this.audioGirl.weaponUpgrade();
                this.level.addWeapon("star", "left");
                this.level.addWeapon("star", "right");
                this.shoot = false;
            }
            if (p.ptype == 1) {
                this.audioGirl.weaponUpgrade();
                this.level.addWeapon("bullet", "front");
                this.shoot = false;
            }
            if (p.ptype != 4) continue;
            this.audioGirl.healthUpgrade();
            this.healthUpgrade = 1.0f;
        }
        this.collider.collide("ship", "enemy");
        esIt = this.collider.get("enemy").iterator();
        for (GameObj s : this.collider.get("ship")) {
            this.audioGirl.hitEnemyC();
            e = esIt.next();
            if (!e.isDying()) {
                s.life -= e.damage;
            }
            if (!e.isBoss()) {
                e.life = 0.0f;
            }
            this.level.health = s.life;
        }
    }

    public void simpleUpdate(float tpf) {
        this.audioGirl.update(tpf);
        if (this.reqGameState != this.curGameState) {
            if (this.reqGameState == "startup") {
                this.loadWaitTimer = 0.0f;
                this.curGameState = "startup";
                this.reqGameState = "startupwait";
            }
            if (this.reqGameState == "startupwait") {
                if (this.loadWaitTimer > 0.5f) {
                    this.audioGirl.modeMenu();
                    this.hud.setFade(1.0f, 0.0f);
                    this.curGameState = "startupwait";
                } else {
                    this.loadWaitTimer += tpf;
                }
            }
            if (this.reqGameState == "gamestart" && this.hud.getFadeVal() == 1.0f) {
                this.stateManager.getState(Menu.class).setEnabled(false);
                this.stateManager.getState(Hud.class).setEnabled(false);
                this.stateManager.getState(Game.class).setEnabled(true);
                this.stateManager.getState(Hud.class).setEnabled(true);
                this.hud.showHud(true);
                this.curGameState = "gamestart";
                this.reqGameState = "gamestartwait";
                this.loadWaitTimer = 0.0f;
            }
            if (this.reqGameState == "gamestartwait") {
                if (this.loadWaitTimer > 1.0f) {
                    this.audioGirl.modeGameStart();
                    this.hud.setFade(1.0f, 0.0f);
                    this.curGameState = "gamestartwait";
                } else {
                    this.loadWaitTimer += tpf;
                }
            }
            if (this.reqGameState == "gamewin") {
                this.curGameState = "gamewin";
                this.reqGameState = "gamewintransition";
                this.audioGirl.modeGameEndWin();
                this.audioGirl.turboJet();
                this.loadWaitTimer = 0.0f;
            }
            if (this.reqGameState == "gamewintransition") {
                if (this.loadWaitTimer > 3.0f) {
                    this.reqGameState = "gamewinfadeout";
                    this.hud.setFade(0.0f, 1.0f);
                    this.loadWaitTimer = 0.0f;
                } else {
                    this.loadWaitTimer += tpf;
                }
            }
            if (this.reqGameState == "gamewinfadeout" && this.hud.getFadeVal() == 1.0f) {
                this.reqGameState = "winscreen";
                this.stateManager.getState(Hud.class).setEnabled(false);
                this.stateManager.getState(Game.class).setEnabled(false);
                this.stateManager.getState(Menu.class).setEnabled(true);
                this.stateManager.getState(Hud.class).setEnabled(true);
                this.hud.showHud(false);
                this.menu.setImage("poster_43_win.jpg");
                this.loadWaitTimer = 0.0f;
            }
            if (this.reqGameState == "winscreen") {
                this.hud.setFade(1.0f, 0.0f);
                this.curGameState = "winscreen";
                ++this.curLevel;
                if (this.curLevel > this.lastLevel) {
                    this.curLevel = this.lastLevel;
                }
            }
            if (this.reqGameState == "gameloose") {
                this.curGameState = "gameloose";
                this.reqGameState = "gameloosetransition";
                this.audioGirl.modeGameEndFail();
                this.loadWaitTimer = 0.0f;
            }
            if (this.reqGameState == "gameloosetransition") {
                if (this.loadWaitTimer > 3.0f) {
                    this.reqGameState = "gameloosefadeout";
                    this.hud.setFade(0.0f, 1.0f);
                    this.loadWaitTimer = 0.0f;
                } else {
                    this.loadWaitTimer += tpf;
                }
            }
            if (this.reqGameState == "gameloosefadeout" && this.hud.getFadeVal() == 1.0f) {
                this.reqGameState = "loosescreen";
                this.stateManager.getState(Hud.class).setEnabled(false);
                this.stateManager.getState(Game.class).setEnabled(false);
                this.stateManager.getState(Menu.class).setEnabled(true);
                this.stateManager.getState(Hud.class).setEnabled(true);
                this.hud.showHud(false);
                this.menu.setImage("poster_43_fail.jpg");
                this.loadWaitTimer = 0.0f;
            }
            if (this.reqGameState == "loosescreen") {
                this.hud.setFade(1.0f, 0.0f);
                this.curGameState = "loosescreen";
            }
        }
    }

    public Hud getHud() {
        return this.hud;
    }

    public void checkReverse(float tpf) {
        if (this.speed < 0.0f) {
            this.level.warp -= 0.3f * tpf;
            if (this.level.warp <= 0.0f) {
                this.speed = -this.speed;
                this.audioGirl.leaveReverseMode();
            }
            this.shoot = false;
            this.warpFact = Math.max(this.warpFact - 2.0f * tpf, 0.0f);
            this.level.score = (float)((double)this.level.score + 10.0 * (double)tpf);
        } else if (this.speed > 0.0f) {
            if (this.level.warp >= 1.0f) {
                this.speed = -this.speed;
                this.audioGirl.enterReverseMode();
            }
            this.warpFact = Math.min(this.warpFact + 2.0f * tpf, 1.0f);
        }
    }

    public void fxUpdate(float tpf) {
        this.warpColor.set(1.0f - 0.2f * (1.0f - this.warpFact), 1.0f - 0.2f * (1.0f - this.warpFact), 1.0f, 1.0f);
        this.light.setColor(this.warpColor);
    }

    public void gameUpdate(float tpf) {
        this.introPhase = this.introPhase * (float)Math.pow(this.shipAccelDamp, tpf) + this.introTime / this.introLength * (1.0f - (float)Math.pow(this.shipAccelDamp, tpf));
        this.collider.reset();
        this.time += this.speed * tpf;
        Vector3f pos = Vector3f.ZERO;
        this.playerCam.update(this.time, tpf, this.rootNode);
        this.updatePlayerOffset(tpf);
        for (Timing p : this.playerCam.active) {
            pos = p.path.getPosition(this.time - p.start, p.obj.speed);
            pos.addLocal(p.offset);
            float directionRotTarget = this.speed > 0.0f ? 0.0f : (float)Math.PI;
            this.directionRot = this.directionRot * (float)Math.pow(this.shipAccelDamp, tpf) + directionRotTarget * (1.0f - (float)Math.pow(this.shipAccelDamp, tpf));
            float winAnimMod = 0.0f;
            if (this.curGameState == "gamewin") {
                winAnimMod = this.outroTime;
            }
            pos.y += winAnimMod;
            p.obj.updatePos(pos.add(this.pOffset), tpf);
            p.obj.updateRot(new Vector3f(this.pSpeed.z * 0.1f + this.directionRot, 0.0f, this.pSpeed.x * -0.1f - this.directionRot), tpf);
            this.cam.setLocation(new Vector3f(0.0f, 5.0f - (1.0f - this.introPhase) * 105.0f, pos.z - 1.5f));
            this.cam.lookAt(new Vector3f(this.pOffset.x * -0.1f, 0.0f - (1.0f - this.introPhase) * 107.0f, 1.5f + pos.z + this.pOffset.z * 0.1f + (1.0f - this.introPhase) * 10.0f), new Vector3f(0.0f, 0.0f, 1.0f));
            this.lightPos.x = pos.x;
            this.lightPos.z = pos.z;
            this.light.setPosition(this.lightPos);
            this.collider.add("ship", p.obj);
            if (this.shoot && this.speed > 0.0f) {
                for (String[] w : this.level.getWeapons()) {
                    this.shots.shoot(w[0], w[1], pos.x + this.pOffset.x, pos.z + this.pOffset.z);
                    if (w[0] == "rocketl") {
                        this.audioGirl.shootWeaponC();
                    }
                    if (w[0] == "star") {
                        this.audioGirl.shootWeaponB();
                    }
                    if (w[0] == "bullet") {
                        this.audioGirl.shootWeaponA();
                    }
                    this.shoot = false;
                }
            }
            float warp = this.speed < 0.0f ? 0.02f : 0.0f;
            p.obj.life = Math.min(p.obj.life + this.healthUpgrade * tpf * 1.0f + warp * tpf * 1.0f, 1.0f);
            this.healthUpgrade = Math.max(this.healthUpgrade - tpf * 1.0f, 0.0f);
            this.level.health = p.obj.life;
            this.shots.update(tpf, p.obj.speed * this.speed, this.collider, "shot");
            for (LevelEvent le : this.level.levelevents) {
                if (!(this.time > le.when) || le.executed.booleanValue()) continue;
                if (le.what == "start") {
                    this.hud.flashOverlay("txt_getready.png", this.settings.getWidth() / 2, this.settings.getHeight() / 2, 643, 152, 1.5f);
                    this.audioGirl.getReady();
                }
                if (le.what == "boss") {
                    this.hud.flashOverlay("txt_bossannounce.png", this.settings.getWidth() / 2, this.settings.getHeight() / 2, 482, 152, 1.0f);
                    this.audioGirl.bossApproaching();
                }
                if (le.what == "wave") {
                    this.audioGirl.spawnEnemy();
                }
                if (le.what == "end") {
                    this.hud.flashOverlay("txt_epicwin.png", this.settings.getWidth() / 2, this.settings.getHeight() / 2, 565, 154, 2.0f);
                    this.reqGameState = "gamewin";
                }
                if (le.what == "level1") {
                    this.hud.flashOverlay("txt_mission1.png", this.settings.getWidth() / 2, this.settings.getHeight() / 2, 580, 194, 2.0f);
                }
                if (le.what == "level2") {
                    this.hud.flashOverlay("txt_mission2.png", this.settings.getWidth() / 2, this.settings.getHeight() / 2, 580, 194, 2.0f);
                }
                if (le.what == "level3") {
                    this.hud.flashOverlay("txt_mission3.png", this.settings.getWidth() / 2, this.settings.getHeight() / 2, 580, 194, 2.0f);
                }
                le.executed = true;
            }
        }
        this.updateEnemies(tpf, pos.z);
        this.updatePowerups(tpf, pos.z);
        this.collide();
        this.checkReverse(tpf);
        this.hud.update(this.level.health * this.introPhase, this.level.warp);
        this.hud.setScore(Math.round(this.level.score));
        this.fxUpdate(tpf);
        if (this.level.isDead() && !this.looseFlag) {
            this.reqGameState = "gameloose";
            this.looseFlag = true;
        }
        if (this.level.bossHealth <= 0.0f && !this.winFlag) {
            this.audioGirl.bossDefeated();
            this.reqGameState = "gamewin";
            this.winFlag = true;
        }
        this.introTime += tpf;
        this.outroTime += tpf;
        this.introTime = Math.min(this.introTime, this.introLength);
        if (this.reqGameState == "gamewin") {
            this.outroTime = 0.0f;
        }
    }

    public void simpleRender(RenderManager rm) {
    }

    public void updatePlayerOffset(float tpf) {
        this.pSpeed.addLocal(this.pAccel.mult(tpf));
        this.pSpeed.minLocal(this.maxSpeed);
        this.pSpeed.maxLocal(this.minSpeed);
        if (this.pOffset.z + this.pSpeed.z * tpf > this.maxOffset.z || this.pOffset.z + this.pSpeed.z * tpf < this.minOffset.z) {
            this.pSpeed.z *= -1.0f;
        }
        if (this.pOffset.x + this.pSpeed.x * tpf > this.maxOffset.x || this.pOffset.x + this.pSpeed.x * tpf < this.minOffset.x) {
            this.pSpeed.x *= -1.0f;
        }
        this.pOffset.x += this.pSpeed.x * tpf;
        this.pOffset.z += this.pSpeed.z * tpf;
        this.pSpeed.multLocal((float)Math.pow(this.shipAccelDamp, tpf));
    }

    public void onAction(String name, boolean isPressed, float tpf) {
        if (this.introTime >= this.introLength) {
            if (name.equals("SPACE") && isPressed) {
                this.speed = -this.speed;
            } else if (name.equals("FW")) {
                this.pAccel.z = isPressed ? this.shipAccel : 0.0f;
            } else if (name.equals("BW")) {
                this.pAccel.z = isPressed ? -this.shipAccel : 0.0f;
            } else if (name.equals("RT")) {
                this.pAccel.x = isPressed ? -this.shipAccel : 0.0f;
            } else if (name.equals("LT")) {
                this.pAccel.x = isPressed ? this.shipAccel : 0.0f;
            } else if (name.equals("SHOOT") && isPressed) {
                this.shoot = true;
            }
        }
    }
}

