/*
 * Decompiled with CFR 0.152.
 */
package mygame;

import java.util.ArrayList;
import java.util.HashMap;
import mygame.GameObj;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColliderHelper {
    HashMap<String, ArrayList<GameObj>> map = new HashMap();
    HashMap<String, ArrayList<GameObj>> col = new HashMap();

    public ColliderHelper(String ... groups) {
        for (String s : groups) {
            this.map.put(s, new ArrayList(200));
            this.col.put(s, new ArrayList(200));
        }
    }

    public void add(String grp, GameObj node) {
        this.map.get(grp).add(node);
    }

    public void reset() {
        for (ArrayList<GameObj> a : this.map.values()) {
            a.clear();
        }
    }

    public void collide(String grp, String with) {
        ArrayList<GameObj> cGrp = this.map.get(grp);
        ArrayList<GameObj> wGrp = this.map.get(with);
        ArrayList<GameObj> cRes = this.col.get(grp);
        ArrayList<GameObj> wRes = this.col.get(with);
        wRes.clear();
        cRes.clear();
        for (GameObj g : cGrp) {
            for (GameObj w : wGrp) {
                float d = g.getLocalTranslation().distance(w.getLocalTranslation());
                if (!(d - w.radius - g.radius < 0.0f)) continue;
                wRes.add(w);
                cRes.add(g);
            }
        }
    }

    public ArrayList<GameObj> get(String grp) {
        return this.col.get(grp);
    }
}

