/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.input.mouse;

import de.lessvoid.nifty.input.NiftyMouseInputEvent;

public class MouseInputEventProcessor {
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private int lastMouseWheel = 0;
    private boolean lastButtonDown0 = false;
    private boolean lastButtonDown1 = false;
    private boolean lastButtonDown2 = false;
    private boolean hadAnyEvents = false;

    public void reset() {
        this.lastButtonDown0 = false;
        this.lastButtonDown1 = false;
        this.lastButtonDown2 = false;
    }

    public void begin() {
        this.hadAnyEvents = false;
    }

    public boolean canProcess(NiftyMouseInputEvent mouseEvent) {
        this.hadAnyEvents = true;
        int mouseX = mouseEvent.getMouseX();
        int mouseY = mouseEvent.getMouseY();
        int mouseWheel = mouseEvent.getMouseWheel();
        boolean button0Down = mouseEvent.isButton0Down();
        boolean button1Down = mouseEvent.isButton1Down();
        boolean button2Down = mouseEvent.isButton2Down();
        return mouseX != this.lastMouseX || mouseY != this.lastMouseY || mouseWheel != 0 || button0Down != this.lastButtonDown0 || button1Down != this.lastButtonDown1 || button2Down != this.lastButtonDown2;
    }

    public void process(NiftyMouseInputEvent mouse) {
        mouse.setButton0InitialDown(!this.lastButtonDown0 && mouse.isButton0Down());
        mouse.setButton0Release(this.lastButtonDown0 && !mouse.isButton0Down());
        mouse.setButton1InitialDown(!this.lastButtonDown1 && mouse.isButton1Down());
        mouse.setButton1Release(this.lastButtonDown1 && !mouse.isButton1Down());
        mouse.setButton2InitialDown(!this.lastButtonDown2 && mouse.isButton2Down());
        mouse.setButton2Release(this.lastButtonDown2 && !mouse.isButton2Down());
        this.lastMouseX = mouse.getMouseX();
        this.lastMouseY = mouse.getMouseY();
        this.lastMouseWheel = mouse.getMouseWheel();
        this.lastButtonDown0 = mouse.isButton0Down();
        this.lastButtonDown1 = mouse.isButton1Down();
        this.lastButtonDown2 = mouse.isButton2Down();
    }

    public boolean hasLastMouseDownEvent() {
        return !this.hadAnyEvents && (this.lastButtonDown0 || this.lastButtonDown1 || this.lastButtonDown2);
    }

    public NiftyMouseInputEvent getLastMouseDownEvent() {
        NiftyMouseInputEvent result = new NiftyMouseInputEvent();
        result.initialize(this.lastMouseX, this.lastMouseY, this.lastMouseWheel, this.lastButtonDown0, this.lastButtonDown1, this.lastButtonDown2);
        return result;
    }
}

