/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.elements;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.MouseClickMethods;
import de.lessvoid.nifty.elements.events.NiftyMousePrimaryClickedEvent;
import de.lessvoid.nifty.elements.events.NiftyMousePrimaryClickedMovedEvent;
import de.lessvoid.nifty.elements.events.NiftyMousePrimaryReleaseEvent;
import de.lessvoid.nifty.input.NiftyMouseInputEvent;

public class PrimaryClickMouseMethods
extends MouseClickMethods {
    public PrimaryClickMouseMethods(Element element) {
        super(element);
    }

    @Override
    public void onInitialClick() {
        if (this.element.isFocusable()) {
            this.element.getFocusHandler().requestExclusiveMouseFocus(this.element);
            this.element.getFocusHandler().setKeyFocus(this.element);
        }
    }

    @Override
    public boolean onClick(Nifty nifty, String onClickAlternateKey, NiftyMouseInputEvent inputEvent) {
        this.publishEvent(nifty, new NiftyMousePrimaryClickedEvent(this.element, inputEvent));
        this.element.startEffect(EffectEventId.onClick);
        return super.onClick(nifty, onClickAlternateKey, inputEvent);
    }

    @Override
    public boolean onClickMouseMove(Nifty nifty, NiftyMouseInputEvent inputEvent) {
        this.publishEvent(nifty, new NiftyMousePrimaryClickedMovedEvent(this.element, inputEvent));
        return super.onClickMouseMove(nifty, inputEvent);
    }

    @Override
    public void onActivate(Nifty nifty) {
        this.publishEvent(nifty, new NiftyMousePrimaryClickedEvent(this.element));
        super.onActivate(nifty);
    }

    @Override
    public boolean onMouseRelease(Nifty nifty, NiftyMouseInputEvent mouseEvent) {
        this.publishEvent(nifty, new NiftyMousePrimaryReleaseEvent(this.element, mouseEvent));
        boolean result = super.onMouseRelease(nifty, mouseEvent);
        this.element.stopEffect(EffectEventId.onClick);
        this.element.getFocusHandler().lostMouseFocus(this.element);
        return result;
    }

    private void publishEvent(Nifty nifty, NiftyEvent<?> event) {
        nifty.publishEvent(this.element.getId(), event);
    }
}

