/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.tools.Alpha;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.LinearInterpolator;

public class Fade
implements EffectImpl {
    private Alpha start = Alpha.ZERO;
    private Alpha end = Alpha.FULL;
    private LinearInterpolator interpolator;

    @Override
    public void activate(Nifty nifty, Element element, EffectProperties parameter) {
        if (parameter.getProperty("startColor") != null) {
            this.start = new Alpha(new Color(parameter.getProperty("startColor", "#000000ff")).getAlpha());
        }
        if (parameter.getProperty("endColor") != null) {
            this.end = new Alpha(new Color(parameter.getProperty("endColor", "#ffffffff")).getAlpha());
        }
        if (parameter.getProperty("start") != null) {
            this.start = new Alpha(parameter.getProperty("start"));
        }
        if (parameter.getProperty("end") != null) {
            this.end = new Alpha(parameter.getProperty("end"));
        }
        this.interpolator = parameter.getInterpolator();
    }

    @Override
    public void execute(Element element, float normalizedTime, Falloff falloff, NiftyRenderEngine r) {
        if (this.interpolator != null) {
            r.setColorAlpha(this.interpolator.getValue(normalizedTime));
        } else {
            Alpha a = this.start.linear(this.end, normalizedTime);
            r.setColorAlpha(a.getAlpha());
        }
    }

    @Override
    public void deactivate() {
    }
}

