/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system.lwjgl;

import com.jme3.input.JoyInput;
import com.jme3.input.KeyInput;
import com.jme3.input.MouseInput;
import com.jme3.input.TouchInput;
import com.jme3.input.lwjgl.JInputJoyInput;
import com.jme3.input.lwjgl.LwjglKeyInput;
import com.jme3.input.lwjgl.LwjglMouseInput;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystem;
import com.jme3.system.lwjgl.LwjglContext;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.opengl.Util;

public abstract class LwjglAbstractDisplay
extends LwjglContext
implements Runnable {
    private static final Logger logger = Logger.getLogger(LwjglAbstractDisplay.class.getName());
    protected AtomicBoolean needClose = new AtomicBoolean(false);
    protected boolean wasActive = false;
    protected int frameRate = 0;
    protected boolean autoFlush = true;

    public abstract JmeContext.Type getType();

    public abstract void setTitle(String var1);

    public abstract void restart();

    protected abstract void createContext(AppSettings var1) throws LWJGLException;

    protected abstract void destroyContext();

    protected void initInThread() {
        try {
            if (!JmeSystem.isLowPermissions()) {
                Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    public void uncaughtException(Thread thread, Throwable thrown) {
                        LwjglAbstractDisplay.this.listener.handleError("Uncaught exception thrown in " + thread.toString(), thrown);
                        if (LwjglAbstractDisplay.this.needClose.get()) {
                            LwjglAbstractDisplay.this.deinitInThread();
                        }
                    }
                });
            }
            this.createContext(this.settings);
            this.printContextInitInfo();
            this.created.set(true);
        }
        catch (Exception ex) {
            try {
                if (Display.isCreated()) {
                    Display.destroy();
                }
            }
            catch (Exception ex2) {
                logger.log(Level.WARNING, null, ex2);
            }
            this.listener.handleError("Failed to create display", (Throwable)ex);
            return;
        }
        super.internalCreate();
        this.listener.initialize();
    }

    protected boolean checkGLError() {
        try {
            Util.checkGLError();
        }
        catch (OpenGLException ex) {
            this.listener.handleError("An OpenGL error has occured!", (Throwable)ex);
        }
        return true;
    }

    protected void runLoop() {
        if (!this.created.get()) {
            throw new IllegalStateException();
        }
        this.listener.update();
        if (this.renderable.get()) {
            assert (this.checkGLError());
            try {
                if (this.autoFlush) {
                    Display.update((boolean)false);
                } else {
                    Display.processMessages();
                    Thread.sleep(50L);
                }
            }
            catch (Throwable ex) {
                this.listener.handleError("Error while swapping buffers", ex);
            }
        }
        if (this.frameRate > 0) {
            Display.sync((int)this.frameRate);
        }
        if (this.renderable.get() && this.autoFlush) {
            Display.processMessages();
        }
        this.renderer.onFrame();
    }

    protected void deinitInThread() {
        this.destroyContext();
        this.listener.destroy();
        logger.info("Display destroyed.");
        super.internalDestroy();
    }

    public void run() {
        if (this.listener == null) {
            throw new IllegalStateException("SystemListener is not set on context!Must set with JmeContext.setSystemListner().");
        }
        logger.log(Level.INFO, "Using LWJGL {0}", Sys.getVersion());
        this.initInThread();
        do {
            if (this.renderable.get()) {
                if (Display.isCloseRequested()) {
                    this.listener.requestClose(false);
                }
                if (this.wasActive != Display.isActive()) {
                    if (!this.wasActive) {
                        this.listener.gainFocus();
                        this.timer.reset();
                        this.wasActive = true;
                    } else {
                        this.listener.loseFocus();
                        this.wasActive = false;
                    }
                }
            }
            this.runLoop();
        } while (!this.needClose.get());
        this.deinitInThread();
    }

    public JoyInput getJoyInput() {
        if (this.joyInput == null) {
            this.joyInput = new JInputJoyInput();
        }
        return this.joyInput;
    }

    public MouseInput getMouseInput() {
        if (this.mouseInput == null) {
            this.mouseInput = new LwjglMouseInput(this);
        }
        return this.mouseInput;
    }

    public KeyInput getKeyInput() {
        if (this.keyInput == null) {
            this.keyInput = new LwjglKeyInput(this);
        }
        return this.keyInput;
    }

    public TouchInput getTouchInput() {
        return null;
    }

    public void setAutoFlushFrames(boolean enabled) {
        this.autoFlush = enabled;
    }

    public void destroy(boolean waitFor) {
        this.needClose.set(true);
        if (waitFor) {
            this.waitFor(false);
        }
    }
}

