/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.heightmap;

import com.jme3.math.FastMath;
import com.jme3.terrain.heightmap.AbstractHeightMap;
import com.jme3.util.LittleEndien;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;

public class RawHeightMap
extends AbstractHeightMap {
    private static final Logger logger = Logger.getLogger(RawHeightMap.class.getName());
    public static final int FORMAT_8BIT = 0;
    public static final int FORMAT_16BITLE = 1;
    public static final int FORMAT_16BITBE = 2;
    private int format;
    private boolean swapxy;
    private InputStream stream;

    public RawHeightMap(String filename, int size) throws Exception {
        this(filename, size, 0, false);
    }

    public RawHeightMap(float[] heightData) {
        this.heightData = heightData;
        this.size = (int)FastMath.sqrt((float)heightData.length);
        this.format = 0;
    }

    public RawHeightMap(String filename, int size, int format, boolean swapxy) throws Exception {
        if (null == filename || size <= 0) {
            throw new Exception("Must supply valid filename and size (> 0)");
        }
        try {
            this.setup(new FileInputStream(filename), size, format, swapxy);
        }
        catch (FileNotFoundException e) {
            throw new Exception("height file not found: " + filename);
        }
    }

    public RawHeightMap(InputStream stream, int size, int format, boolean swapxy) throws Exception {
        this.setup(stream, size, format, swapxy);
    }

    public RawHeightMap(URL resource, int size, int format, boolean swapxy) throws Exception {
        if (null == resource || size <= 0) {
            throw new Exception("Must supply valid resource and size (> 0)");
        }
        try {
            this.setup(resource.openStream(), size, format, swapxy);
        }
        catch (IOException e) {
            throw new Exception("Unable to open height url: " + resource);
        }
    }

    private void setup(InputStream stream, int size, int format, boolean swapxy) throws Exception {
        if (null == stream || size <= 0) {
            throw new Exception("Must supply valid stream and size (> 0)");
        }
        this.stream = stream;
        this.size = size;
        this.format = format;
        this.swapxy = swapxy;
        this.load();
    }

    public boolean load() {
        if (null == this.stream || this.size <= 0) {
            throw new RuntimeException("Must supply valid stream and size (> 0)");
        }
        if (null != this.heightData) {
            this.unloadHeightMap();
        }
        this.heightData = new float[this.size * this.size];
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(this.stream);
            if (this.format == 1) {
                LittleEndien dis = new LittleEndien((InputStream)bis);
                for (int i = 0; i < this.size; ++i) {
                    for (int j = 0; j < this.size; ++j) {
                        int index = this.swapxy ? i + j * this.size : i * this.size + j;
                        this.heightData[index] = dis.readUnsignedShort();
                    }
                }
                dis.close();
            } else {
                DataInputStream dis = new DataInputStream(bis);
                for (int i = 0; i < this.size; ++i) {
                    for (int j = 0; j < this.size; ++j) {
                        int index = this.swapxy ? i + j * this.size : i * this.size + j;
                        this.heightData[index] = this.format == 2 ? (float)dis.readUnsignedShort() : (float)dis.readUnsignedByte();
                    }
                }
                dis.close();
            }
            bis.close();
        }
        catch (IOException e1) {
            logger.warning("Error reading height data from stream.");
            return false;
        }
        return true;
    }

    public void setFilename(String filename) throws Exception {
        if (null == filename) {
            throw new Exception("Must supply valid filename.");
        }
        try {
            this.stream = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            throw new Exception("height file not found: " + filename);
        }
    }

    public void setHeightStream(InputStream stream) throws Exception {
        if (null == stream) {
            throw new Exception("Must supply valid stream.");
        }
        this.stream = stream;
    }
}

