/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.heightmap;

import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.asset.TextureKey;
import com.jme3.math.Vector3f;
import com.jme3.terrain.heightmap.HeightMap;
import com.jme3.terrain.heightmap.HeightMapGrid;
import com.jme3.terrain.heightmap.ImageBasedHeightMap;
import com.jme3.terrain.heightmap.Namer;
import com.jme3.texture.Texture;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
public class ImageBasedHeightMapGrid
implements HeightMapGrid {
    private static final Logger logger = Logger.getLogger(ImageBasedHeightMapGrid.class.getName());
    private final AssetManager assetManager;
    private final Namer namer;
    private int size;

    public ImageBasedHeightMapGrid(final String textureBase, final String textureExt, AssetManager assetManager) {
        this(assetManager, new Namer(){

            public String getName(int x, int y) {
                return textureBase + "_" + x + "_" + y + "." + textureExt;
            }
        });
    }

    public ImageBasedHeightMapGrid(AssetManager assetManager, Namer namer) {
        this.assetManager = assetManager;
        this.namer = namer;
    }

    public HeightMap getHeightMapAt(Vector3f location) {
        int x = (int)location.x;
        int z = (int)location.z;
        ImageBasedHeightMap heightmap = null;
        try {
            String name = this.namer.getName(x, z);
            logger.log(Level.INFO, "Loading heightmap from file: {0}", name);
            Texture texture = this.assetManager.loadTexture(new TextureKey(name));
            heightmap = new ImageBasedHeightMap(texture.getImage());
            heightmap.setHeightScale(1.0f);
            heightmap.load();
        }
        catch (AssetNotFoundException e) {
            logger.log(Level.SEVERE, "Asset Not found! ", e);
        }
        return heightmap;
    }

    public void setSize(int size) {
        this.size = size - 1;
    }
}

