/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap.lodcalc;

import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.renderer.Camera;
import com.jme3.terrain.geomipmap.TerrainPatch;
import com.jme3.terrain.geomipmap.lodcalc.LodCalculator;
import com.jme3.terrain.geomipmap.lodcalc.LodCalculatorFactory;
import com.jme3.terrain.geomipmap.lodcalc.PerspectiveLodCalculator;
import java.io.IOException;

public class LodPerspectiveCalculatorFactory
implements LodCalculatorFactory {
    private Camera cam;
    private float pixelError;

    public LodPerspectiveCalculatorFactory(Camera cam, float pixelError) {
        this.cam = cam;
        this.pixelError = pixelError;
    }

    public LodCalculator createCalculator() {
        return new PerspectiveLodCalculator(this.cam, this.pixelError);
    }

    public LodCalculator createCalculator(TerrainPatch terrainPatch) {
        PerspectiveLodCalculator p = new PerspectiveLodCalculator(this.cam, this.pixelError);
        return p;
    }

    public void write(JmeExporter ex) throws IOException {
    }

    public void read(JmeImporter im) throws IOException {
    }

    public LodCalculatorFactory clone() {
        try {
            return (LodCalculatorFactory)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }
}

