/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision;

import com.jme3.asset.AssetManager;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.util.DebugShapeFactory;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import java.io.IOException;
import java.util.List;

public abstract class PhysicsCollisionObject
implements Savable {
    protected Spatial debugShape;
    protected Arrow debugArrow;
    protected Geometry debugArrowGeom;
    protected Material debugMaterialBlue;
    protected Material debugMaterialRed;
    protected Material debugMaterialGreen;
    protected Material debugMaterialYellow;
    protected CollisionShape collisionShape;
    public static final int COLLISION_GROUP_NONE = 0;
    public static final int COLLISION_GROUP_01 = 1;
    public static final int COLLISION_GROUP_02 = 2;
    public static final int COLLISION_GROUP_03 = 4;
    public static final int COLLISION_GROUP_04 = 8;
    public static final int COLLISION_GROUP_05 = 16;
    public static final int COLLISION_GROUP_06 = 32;
    public static final int COLLISION_GROUP_07 = 64;
    public static final int COLLISION_GROUP_08 = 128;
    public static final int COLLISION_GROUP_09 = 256;
    public static final int COLLISION_GROUP_10 = 512;
    public static final int COLLISION_GROUP_11 = 1024;
    public static final int COLLISION_GROUP_12 = 2048;
    public static final int COLLISION_GROUP_13 = 4096;
    public static final int COLLISION_GROUP_14 = 8192;
    public static final int COLLISION_GROUP_15 = 16384;
    public static final int COLLISION_GROUP_16 = 32768;
    protected int collisionGroup = 1;
    protected int collisionGroupsMask = 1;
    private Object userObject;

    public void setCollisionShape(CollisionShape collisionShape) {
        this.collisionShape = collisionShape;
        this.updateDebugShape();
    }

    public CollisionShape getCollisionShape() {
        return this.collisionShape;
    }

    public int getCollisionGroup() {
        return this.collisionGroup;
    }

    public void setCollisionGroup(int collisionGroup) {
        this.collisionGroup = collisionGroup;
    }

    public void addCollideWithGroup(int collisionGroup) {
        this.collisionGroupsMask |= collisionGroup;
    }

    public void removeCollideWithGroup(int collisionGroup) {
        this.collisionGroupsMask &= ~collisionGroup;
    }

    public void setCollideWithGroups(int collisionGroups) {
        this.collisionGroupsMask = collisionGroups;
    }

    public int getCollideWithGroups() {
        return this.collisionGroupsMask;
    }

    protected Spatial attachDebugShape(AssetManager manager) {
        this.debugMaterialBlue = new Material(manager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.debugMaterialBlue.getAdditionalRenderState().setWireframe(true);
        this.debugMaterialBlue.setColor("Color", ColorRGBA.Blue);
        this.debugMaterialGreen = new Material(manager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.debugMaterialGreen.getAdditionalRenderState().setWireframe(true);
        this.debugMaterialGreen.setColor("Color", ColorRGBA.Green);
        this.debugMaterialRed = new Material(manager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.debugMaterialRed.getAdditionalRenderState().setWireframe(true);
        this.debugMaterialRed.setColor("Color", ColorRGBA.Red);
        this.debugMaterialYellow = new Material(manager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.debugMaterialYellow.getAdditionalRenderState().setWireframe(true);
        this.debugMaterialYellow.setColor("Color", ColorRGBA.Yellow);
        this.debugArrow = new Arrow(Vector3f.UNIT_XYZ);
        this.debugArrowGeom = new Geometry("DebugArrow", (Mesh)this.debugArrow);
        this.debugArrowGeom.setMaterial(this.debugMaterialGreen);
        return this.attachDebugShape();
    }

    public Spatial createDebugShape(AssetManager manager) {
        return this.attachDebugShape(manager);
    }

    protected Spatial attachDebugShape(Material material) {
        this.debugMaterialBlue = material;
        this.debugMaterialGreen = material;
        this.debugMaterialRed = material;
        this.debugMaterialYellow = material;
        this.debugArrow = new Arrow(Vector3f.UNIT_XYZ);
        this.debugArrowGeom = new Geometry("DebugArrow", (Mesh)this.debugArrow);
        this.debugArrowGeom.setMaterial(this.debugMaterialGreen);
        return this.attachDebugShape();
    }

    public Spatial debugShape() {
        return this.debugShape;
    }

    protected Spatial attachDebugShape() {
        Spatial spatial;
        if (this.debugShape != null) {
            this.detachDebugShape();
        }
        this.debugShape = spatial = this.getDebugShape();
        return this.debugShape;
    }

    protected void updateDebugShape() {
        if (this.debugShape != null) {
            this.detachDebugShape();
            this.attachDebugShape();
        }
    }

    protected Spatial getDebugShape() {
        Spatial spatial = DebugShapeFactory.getDebugShape(this.collisionShape);
        if (spatial == null) {
            return new Node("nullnode");
        }
        if (spatial instanceof Node) {
            List children = ((Node)spatial).getChildren();
            for (Spatial spatial1 : children) {
                Geometry geom = (Geometry)spatial1;
                geom.setMaterial(this.debugMaterialBlue);
                geom.setCullHint(Spatial.CullHint.Never);
            }
        } else {
            Geometry geom = (Geometry)spatial;
            geom.setMaterial(this.debugMaterialBlue);
            geom.setCullHint(Spatial.CullHint.Never);
        }
        spatial.setCullHint(Spatial.CullHint.Never);
        return spatial;
    }

    public void detachDebugShape() {
        this.debugShape = null;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public void write(JmeExporter e) throws IOException {
        OutputCapsule capsule = e.getCapsule((Savable)this);
        capsule.write(this.collisionGroup, "collisionGroup", 1);
        capsule.write(this.collisionGroupsMask, "collisionGroupsMask", 1);
        capsule.write((Savable)this.debugShape, "debugShape", null);
        capsule.write((Savable)this.collisionShape, "collisionShape", null);
    }

    public void read(JmeImporter e) throws IOException {
        CollisionShape shape;
        InputCapsule capsule = e.getCapsule((Savable)this);
        this.collisionGroup = capsule.readInt("collisionGroup", 1);
        this.collisionGroupsMask = capsule.readInt("collisionGroupsMask", 1);
        this.debugShape = (Spatial)capsule.readSavable("debugShape", null);
        this.collisionShape = shape = (CollisionShape)capsule.readSavable("collisionShape", null);
    }
}

