/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post.filters;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;

public class GammaCorrectionFilter
extends Filter {
    private float gamma = 2.0f;
    private boolean computeLuma = false;

    public GammaCorrectionFilter() {
        super("GammaCorrectionFilter");
    }

    public GammaCorrectionFilter(float gamma) {
        this();
        this.setGamma(gamma);
    }

    protected Material getMaterial() {
        return this.material;
    }

    protected void initFilter(AssetManager manager, RenderManager renderManager, ViewPort vp, int w, int h) {
        this.material = new Material(manager, "Common/MatDefs/Post/GammaCorrection.j3md");
        this.material.setFloat("gamma", this.gamma);
        this.material.setBoolean("computeLuma", this.computeLuma);
    }

    public float getGamma() {
        return this.gamma;
    }

    public void setGamma(float gamma) {
        if (this.material != null) {
            this.material.setFloat("gamma", gamma);
        }
        this.gamma = gamma;
    }

    public boolean isComputeLuma() {
        return this.computeLuma;
    }

    public void setComputeLuma(boolean computeLuma) {
        if (this.material != null) {
            this.material.setBoolean("computeLuma", computeLuma);
        }
        this.computeLuma = computeLuma;
    }
}

