/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TangentBinormalGenerator {
    private static final float ZERO_TOLERANCE = 1.0E-7f;
    private static final Logger log = Logger.getLogger(TangentBinormalGenerator.class.getName());
    private static float toleranceAngle;
    private static float toleranceDot;

    private static VertexData[] initVertexData(int size) {
        VertexData[] vertices = new VertexData[size];
        for (int i = 0; i < size; ++i) {
            vertices[i] = new VertexData();
        }
        return vertices;
    }

    public static void generate(Mesh mesh) {
        TangentBinormalGenerator.generate(mesh, true);
    }

    public static void generate(Spatial scene) {
        if (scene instanceof Node) {
            Node node = (Node)scene;
            for (Spatial child : node.getChildren()) {
                TangentBinormalGenerator.generate(child);
            }
        } else {
            Geometry geom = (Geometry)scene;
            Mesh mesh = geom.getMesh();
            if (mesh.getBuffer(VertexBuffer.Type.TexCoord) != null && mesh.getBuffer(VertexBuffer.Type.Normal) != null) {
                TangentBinormalGenerator.generate(geom.getMesh());
            }
        }
    }

    public static void generate(Mesh mesh, boolean approxTangents) {
        VertexBuffer tangents;
        VertexData[] vertices;
        int[] index = new int[3];
        Vector3f[] v = new Vector3f[3];
        Vector2f[] t = new Vector2f[3];
        for (int i = 0; i < 3; ++i) {
            v[i] = new Vector3f();
            t[i] = new Vector2f();
        }
        if (mesh.getBuffer(VertexBuffer.Type.Normal) == null) {
            throw new IllegalArgumentException("The given mesh has no normal data!");
        }
        switch (mesh.getMode()) {
            case Triangles: {
                vertices = TangentBinormalGenerator.processTriangles(mesh, index, v, t);
                break;
            }
            case TriangleStrip: {
                vertices = TangentBinormalGenerator.processTriangleStrip(mesh, index, v, t);
                break;
            }
            case TriangleFan: {
                vertices = TangentBinormalGenerator.processTriangleFan(mesh, index, v, t);
                break;
            }
            default: {
                throw new UnsupportedOperationException((Object)((Object)mesh.getMode()) + " is not supported.");
            }
        }
        TangentBinormalGenerator.processTriangleData(mesh, vertices, approxTangents);
        if (mesh.getBuffer(VertexBuffer.Type.BindPosePosition) != null && (tangents = mesh.getBuffer(VertexBuffer.Type.Tangent)) != null) {
            VertexBuffer bindTangents = new VertexBuffer(VertexBuffer.Type.BindPoseTangent);
            bindTangents.setupData(VertexBuffer.Usage.CpuOnly, 4, VertexBuffer.Format.Float, BufferUtils.clone(tangents.getData()));
            if (mesh.getBuffer(VertexBuffer.Type.BindPoseTangent) != null) {
                mesh.clearBuffer(VertexBuffer.Type.BindPoseTangent);
            }
            mesh.setBuffer(bindTangents);
            tangents.setUsage(VertexBuffer.Usage.Stream);
        }
    }

    private static VertexData[] processTriangles(Mesh mesh, int[] index, Vector3f[] v, Vector2f[] t) {
        IndexBuffer indexBuffer = mesh.getIndexBuffer();
        FloatBuffer vertexBuffer = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.Position).getData();
        if (mesh.getBuffer(VertexBuffer.Type.TexCoord) == null) {
            throw new IllegalArgumentException("Can only generate tangents for meshes with texture coordinates");
        }
        FloatBuffer textureBuffer = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.TexCoord).getData();
        VertexData[] vertices = TangentBinormalGenerator.initVertexData(vertexBuffer.capacity() / 3);
        for (int i = 0; i < indexBuffer.size() / 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                index[j] = indexBuffer.get(i * 3 + j);
                BufferUtils.populateFromBuffer(v[j], vertexBuffer, index[j]);
                BufferUtils.populateFromBuffer(t[j], textureBuffer, index[j]);
            }
            TriangleData triData = TangentBinormalGenerator.processTriangle(index, v, t);
            if (triData == null) continue;
            vertices[index[0]].triangles.add(triData);
            vertices[index[1]].triangles.add(triData);
            vertices[index[2]].triangles.add(triData);
        }
        return vertices;
    }

    private static VertexData[] processTriangleStrip(Mesh mesh, int[] index, Vector3f[] v, Vector2f[] t) {
        IndexBuffer indexBuffer = mesh.getIndexBuffer();
        FloatBuffer vertexBuffer = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.Position).getData();
        FloatBuffer textureBuffer = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.TexCoord).getData();
        VertexData[] vertices = TangentBinormalGenerator.initVertexData(vertexBuffer.capacity() / 3);
        index[0] = indexBuffer.get(0);
        index[1] = indexBuffer.get(1);
        BufferUtils.populateFromBuffer(v[0], vertexBuffer, index[0]);
        BufferUtils.populateFromBuffer(v[1], vertexBuffer, index[1]);
        BufferUtils.populateFromBuffer(t[0], textureBuffer, index[0]);
        BufferUtils.populateFromBuffer(t[1], textureBuffer, index[1]);
        for (int i = 2; i < indexBuffer.size(); ++i) {
            index[2] = indexBuffer.get(i);
            BufferUtils.populateFromBuffer(v[2], vertexBuffer, index[2]);
            BufferUtils.populateFromBuffer(t[2], textureBuffer, index[2]);
            boolean isDegenerate = TangentBinormalGenerator.isDegenerateTriangle(v[0], v[1], v[2]);
            TriangleData triData = TangentBinormalGenerator.processTriangle(index, v, t);
            if (triData != null && !isDegenerate) {
                vertices[index[0]].triangles.add(triData);
                vertices[index[1]].triangles.add(triData);
                vertices[index[2]].triangles.add(triData);
            }
            Vector3f vTemp = v[0];
            v[0] = v[1];
            v[1] = v[2];
            v[2] = vTemp;
            Vector2f tTemp = t[0];
            t[0] = t[1];
            t[1] = t[2];
            t[2] = tTemp;
            index[0] = index[1];
            index[1] = index[2];
        }
        return vertices;
    }

    private static VertexData[] processTriangleFan(Mesh mesh, int[] index, Vector3f[] v, Vector2f[] t) {
        IndexBuffer indexBuffer = mesh.getIndexBuffer();
        FloatBuffer vertexBuffer = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.Position).getData();
        FloatBuffer textureBuffer = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.TexCoord).getData();
        VertexData[] vertices = TangentBinormalGenerator.initVertexData(vertexBuffer.capacity() / 3);
        index[0] = indexBuffer.get(0);
        index[1] = indexBuffer.get(1);
        BufferUtils.populateFromBuffer(v[0], vertexBuffer, index[0]);
        BufferUtils.populateFromBuffer(v[1], vertexBuffer, index[1]);
        BufferUtils.populateFromBuffer(t[0], textureBuffer, index[0]);
        BufferUtils.populateFromBuffer(t[1], textureBuffer, index[1]);
        for (int i = 2; i < vertexBuffer.capacity() / 3; ++i) {
            index[2] = indexBuffer.get(i);
            BufferUtils.populateFromBuffer(v[2], vertexBuffer, index[2]);
            BufferUtils.populateFromBuffer(t[2], textureBuffer, index[2]);
            TriangleData triData = TangentBinormalGenerator.processTriangle(index, v, t);
            if (triData != null) {
                vertices[index[0]].triangles.add(triData);
                vertices[index[1]].triangles.add(triData);
                vertices[index[2]].triangles.add(triData);
            }
            Vector3f vTemp = v[1];
            v[1] = v[2];
            v[2] = vTemp;
            Vector2f tTemp = t[1];
            t[1] = t[2];
            t[2] = tTemp;
            index[1] = index[2];
        }
        return vertices;
    }

    private static boolean isDegenerateTriangle(Vector3f a, Vector3f b, Vector3f c) {
        return a.subtract(b).cross(c.subtract(b)).lengthSquared() == 0.0f;
    }

    public static TriangleData processTriangle(int[] index, Vector3f[] v, Vector2f[] t) {
        Vector3f edge1 = new Vector3f();
        Vector3f edge2 = new Vector3f();
        Vector2f edge1uv = new Vector2f();
        Vector2f edge2uv = new Vector2f();
        Vector3f tangent = new Vector3f();
        Vector3f binormal = new Vector3f();
        Vector3f normal = new Vector3f();
        t[1].subtract(t[0], edge1uv);
        t[2].subtract(t[0], edge2uv);
        float det = edge1uv.x * edge2uv.y - edge1uv.y * edge2uv.x;
        boolean normalize = false;
        if (Math.abs(det) < 1.0E-7f) {
            log.log(Level.WARNING, "Colinear uv coordinates for triangle [{0}, {1}, {2}]; tex0 = [{3}, {4}], tex1 = [{5}, {6}], tex2 = [{7}, {8}]", new Object[]{index[0], index[1], index[2], Float.valueOf(t[0].x), Float.valueOf(t[0].y), Float.valueOf(t[1].x), Float.valueOf(t[1].y), Float.valueOf(t[2].x), Float.valueOf(t[2].y)});
            det = 1.0f;
            normalize = true;
        }
        v[1].subtract(v[0], edge1);
        v[2].subtract(v[0], edge2);
        tangent.set(edge1);
        tangent.normalizeLocal();
        binormal.set(edge2);
        binormal.normalizeLocal();
        if (Math.abs(Math.abs(tangent.dot(binormal)) - 1.0f) < 1.0E-7f) {
            log.log(Level.WARNING, "Vertices are on the same line for triangle [{0}, {1}, {2}].", new Object[]{index[0], index[1], index[2]});
        }
        float factor = 1.0f / det;
        tangent.x = (edge2uv.y * edge1.x - edge1uv.y * edge2.x) * factor;
        tangent.y = (edge2uv.y * edge1.y - edge1uv.y * edge2.y) * factor;
        tangent.z = (edge2uv.y * edge1.z - edge1uv.y * edge2.z) * factor;
        if (normalize) {
            tangent.normalizeLocal();
        }
        binormal.x = (edge1uv.x * edge2.x - edge2uv.x * edge1.x) * factor;
        binormal.y = (edge1uv.x * edge2.y - edge2uv.x * edge1.y) * factor;
        binormal.z = (edge1uv.x * edge2.z - edge2uv.x * edge1.z) * factor;
        if (normalize) {
            binormal.normalizeLocal();
        }
        tangent.cross(binormal, normal);
        normal.normalizeLocal();
        return new TriangleData(tangent, binormal, normal);
    }

    public static void setToleranceAngle(float angle) {
        if (angle < 0.0f || angle > 179.0f) {
            throw new IllegalArgumentException("The angle must be between 0 and 179 degrees.");
        }
        toleranceDot = FastMath.cos(angle * ((float)Math.PI / 180));
        toleranceAngle = angle;
    }

    private static boolean approxEqual(Vector3f u, Vector3f v) {
        float tolerance = 1.0E-4f;
        return FastMath.abs(u.x - v.x) < tolerance && FastMath.abs(u.y - v.y) < tolerance && FastMath.abs(u.z - v.z) < tolerance;
    }

    private static boolean approxEqual(Vector2f u, Vector2f v) {
        float tolerance = 1.0E-4f;
        return FastMath.abs(u.x - v.x) < tolerance && FastMath.abs(u.y - v.y) < tolerance;
    }

    private static ArrayList<VertexInfo> linkVertices(Mesh mesh) {
        ArrayList<VertexInfo> vertexMap = new ArrayList<VertexInfo>();
        FloatBuffer vertexBuffer = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        FloatBuffer normalBuffer = mesh.getFloatBuffer(VertexBuffer.Type.Normal);
        FloatBuffer texcoordBuffer = mesh.getFloatBuffer(VertexBuffer.Type.TexCoord);
        Vector3f position = new Vector3f();
        Vector3f normal = new Vector3f();
        Vector2f texCoord = new Vector2f();
        int size = vertexBuffer.capacity() / 3;
        for (int i = 0; i < size; ++i) {
            BufferUtils.populateFromBuffer(position, vertexBuffer, i);
            BufferUtils.populateFromBuffer(normal, normalBuffer, i);
            BufferUtils.populateFromBuffer(texCoord, texcoordBuffer, i);
            boolean found = false;
            for (int j = 0; j < vertexMap.size(); ++j) {
                VertexInfo vertexInfo = vertexMap.get(j);
                if (!TangentBinormalGenerator.approxEqual(vertexInfo.position, position) || !TangentBinormalGenerator.approxEqual(vertexInfo.normal, normal) || !TangentBinormalGenerator.approxEqual(vertexInfo.texCoord, texCoord)) continue;
                vertexInfo.indices.add(i);
                found = true;
                break;
            }
            if (found) continue;
            VertexInfo vertexInfo = new VertexInfo(position.clone(), normal.clone(), texCoord.clone());
            vertexInfo.indices.add(i);
            vertexMap.add(vertexInfo);
        }
        return vertexMap;
    }

    private static void processTriangleData(Mesh mesh, VertexData[] vertices, boolean approxTangent) {
        ArrayList<VertexInfo> vertexMap = TangentBinormalGenerator.linkVertices(mesh);
        FloatBuffer normalBuffer = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.Normal).getData();
        FloatBuffer tangents = BufferUtils.createFloatBuffer(vertices.length * 4);
        Vector3f tangent = new Vector3f();
        Vector3f binormal = new Vector3f();
        Vector3f normal = new Vector3f();
        Vector3f givenNormal = new Vector3f();
        Vector3f tangentUnit = new Vector3f();
        Vector3f binormalUnit = new Vector3f();
        for (int k = 0; k < vertexMap.size(); ++k) {
            float wCoord = -1.0f;
            VertexInfo vertexInfo = vertexMap.get(k);
            givenNormal.set(vertexInfo.normal);
            givenNormal.normalizeLocal();
            TriangleData firstTriangle = vertices[vertexInfo.indices.get((int)0).intValue()].triangles.get(0);
            tangent.set(firstTriangle.tangent);
            tangent.normalizeLocal();
            binormal.set(firstTriangle.binormal);
            binormal.normalizeLocal();
            block1: for (int i : vertexInfo.indices) {
                ArrayList<TriangleData> triangles = vertices[i].triangles;
                for (int j = 0; j < triangles.size(); ++j) {
                    TriangleData triangleData = triangles.get(j);
                    tangentUnit.set(triangleData.tangent);
                    tangentUnit.normalizeLocal();
                    if (tangent.dot(tangentUnit) < toleranceDot) {
                        log.log(Level.WARNING, "Angle between tangents exceeds tolerance for vertex {0}.", i);
                        continue block1;
                    }
                    if (approxTangent) continue;
                    binormalUnit.set(triangleData.binormal);
                    binormalUnit.normalizeLocal();
                    if (!(binormal.dot(binormalUnit) < toleranceDot)) continue;
                    log.log(Level.WARNING, "Angle between binormals exceeds tolerance for vertex {0}.", i);
                    continue block1;
                }
            }
            tangent.set(0.0f, 0.0f, 0.0f);
            binormal.set(0.0f, 0.0f, 0.0f);
            int triangleCount = 0;
            for (int i : vertexInfo.indices) {
                ArrayList<TriangleData> triangles = vertices[i].triangles;
                triangleCount += triangles.size();
                boolean flippedNormal = false;
                for (int j = 0; j < triangles.size(); ++j) {
                    TriangleData triangleData = triangles.get(j);
                    tangent.addLocal(triangleData.tangent);
                    binormal.addLocal(triangleData.binormal);
                    if (!(givenNormal.dot(triangleData.normal) < 0.0f)) continue;
                    flippedNormal = true;
                }
                if (!flippedNormal) continue;
                wCoord = 1.0f;
            }
            int blameVertex = vertexInfo.indices.get(0);
            if (tangent.length() < 1.0E-7f) {
                log.log(Level.WARNING, "Shared tangent is zero for vertex {0}.", blameVertex);
                if (binormal.length() >= 1.0E-7f) {
                    binormal.cross(givenNormal, tangent);
                    tangent.normalizeLocal();
                } else {
                    tangent.set(firstTriangle.tangent);
                }
            } else {
                tangent.divideLocal(triangleCount);
            }
            tangentUnit.set(tangent);
            tangentUnit.normalizeLocal();
            if (Math.abs(Math.abs(tangentUnit.dot(givenNormal)) - 1.0f) < 1.0E-7f) {
                log.log(Level.WARNING, "Normal and tangent are parallel for vertex {0}.", blameVertex);
            }
            if (!approxTangent) {
                if (binormal.length() < 1.0E-7f) {
                    log.log(Level.WARNING, "Shared binormal is zero for vertex {0}.", blameVertex);
                    if (tangent.length() >= 1.0E-7f) {
                        givenNormal.cross(tangent, binormal);
                        binormal.normalizeLocal();
                    } else {
                        binormal.set(firstTriangle.binormal);
                    }
                } else {
                    binormal.divideLocal(triangleCount);
                }
                binormalUnit.set(binormal);
                binormalUnit.normalizeLocal();
                if (Math.abs(Math.abs(binormalUnit.dot(givenNormal)) - 1.0f) < 1.0E-7f) {
                    log.log(Level.WARNING, "Normal and binormal are parallel for vertex {0}.", blameVertex);
                }
                if (Math.abs(Math.abs(binormalUnit.dot(tangentUnit)) - 1.0f) < 1.0E-7f) {
                    log.log(Level.WARNING, "Tangent and binormal are parallel for vertex {0}.", blameVertex);
                }
            }
            for (int i : vertexInfo.indices) {
                if (approxTangent) {
                    givenNormal.cross(tangent, binormal);
                    binormal.cross(givenNormal, tangent);
                    tangent.normalizeLocal();
                    tangents.put(i * 4, tangent.x);
                    tangents.put(i * 4 + 1, tangent.y);
                    tangents.put(i * 4 + 2, tangent.z);
                    tangents.put(i * 4 + 3, wCoord);
                    continue;
                }
                tangents.put(i * 4, tangent.x);
                tangents.put(i * 4 + 1, tangent.y);
                tangents.put(i * 4 + 2, tangent.z);
                tangents.put(i * 4 + 3, wCoord);
            }
        }
        mesh.setBuffer(VertexBuffer.Type.Tangent, 4, tangents);
    }

    public static Mesh genTbnLines(Mesh mesh, float scale) {
        if (mesh.getBuffer(VertexBuffer.Type.Tangent) == null) {
            return TangentBinormalGenerator.genNormalLines(mesh, scale);
        }
        return TangentBinormalGenerator.genTangentLines(mesh, scale);
    }

    public static Mesh genNormalLines(Mesh mesh, float scale) {
        FloatBuffer vertexBuffer = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.Position).getData();
        FloatBuffer normalBuffer = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.Normal).getData();
        ColorRGBA originColor = ColorRGBA.White;
        ColorRGBA normalColor = ColorRGBA.Blue;
        Mesh lineMesh = new Mesh();
        lineMesh.setMode(Mesh.Mode.Lines);
        Vector3f origin = new Vector3f();
        Vector3f point = new Vector3f();
        FloatBuffer lineVertex = BufferUtils.createFloatBuffer(vertexBuffer.capacity() * 2);
        FloatBuffer lineColor = BufferUtils.createFloatBuffer(vertexBuffer.capacity() / 3 * 4 * 2);
        for (int i = 0; i < vertexBuffer.capacity() / 3; ++i) {
            BufferUtils.populateFromBuffer(origin, vertexBuffer, i);
            BufferUtils.populateFromBuffer(point, normalBuffer, i);
            int index = i * 2;
            BufferUtils.setInBuffer(origin, lineVertex, index);
            BufferUtils.setInBuffer(originColor, lineColor, index);
            point.multLocal(scale);
            point.addLocal(origin);
            BufferUtils.setInBuffer(point, lineVertex, index + 1);
            BufferUtils.setInBuffer(normalColor, lineColor, index + 1);
        }
        lineMesh.setBuffer(VertexBuffer.Type.Position, 3, lineVertex);
        lineMesh.setBuffer(VertexBuffer.Type.Color, 4, lineColor);
        lineMesh.setStatic();
        return lineMesh;
    }

    private static Mesh genTangentLines(Mesh mesh, float scale) {
        FloatBuffer vertexBuffer = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.Position).getData();
        FloatBuffer normalBuffer = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.Normal).getData();
        FloatBuffer tangentBuffer = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.Tangent).getData();
        FloatBuffer binormalBuffer = null;
        if (mesh.getBuffer(VertexBuffer.Type.Binormal) != null) {
            binormalBuffer = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.Binormal).getData();
        }
        ColorRGBA originColor = ColorRGBA.White;
        ColorRGBA tangentColor = ColorRGBA.Red;
        ColorRGBA binormalColor = ColorRGBA.Green;
        ColorRGBA normalColor = ColorRGBA.Blue;
        Mesh lineMesh = new Mesh();
        lineMesh.setMode(Mesh.Mode.Lines);
        Vector3f origin = new Vector3f();
        Vector3f point = new Vector3f();
        Vector3f tangent = new Vector3f();
        Vector3f normal = new Vector3f();
        IntBuffer lineIndex = BufferUtils.createIntBuffer(vertexBuffer.capacity() / 3 * 6);
        FloatBuffer lineVertex = BufferUtils.createFloatBuffer(vertexBuffer.capacity() * 4);
        FloatBuffer lineColor = BufferUtils.createFloatBuffer(vertexBuffer.capacity() / 3 * 4 * 4);
        boolean hasParity = mesh.getBuffer(VertexBuffer.Type.Tangent).getNumComponents() == 4;
        float tangentW = 1.0f;
        for (int i = 0; i < vertexBuffer.capacity() / 3; ++i) {
            BufferUtils.populateFromBuffer(origin, vertexBuffer, i);
            BufferUtils.populateFromBuffer(normal, normalBuffer, i);
            if (hasParity) {
                tangent.x = tangentBuffer.get(i * 4);
                tangent.y = tangentBuffer.get(i * 4 + 1);
                tangent.z = tangentBuffer.get(i * 4 + 2);
                tangentW = tangentBuffer.get(i * 4 + 3);
            } else {
                BufferUtils.populateFromBuffer(tangent, tangentBuffer, i);
            }
            int index = i * 4;
            int id = i * 6;
            lineIndex.put(id, index);
            lineIndex.put(id + 1, index + 1);
            lineIndex.put(id + 2, index);
            lineIndex.put(id + 3, index + 2);
            lineIndex.put(id + 4, index);
            lineIndex.put(id + 5, index + 3);
            BufferUtils.setInBuffer(origin, lineVertex, index);
            BufferUtils.setInBuffer(originColor, lineColor, index);
            point.set(tangent);
            point.multLocal(scale);
            point.addLocal(origin);
            BufferUtils.setInBuffer(point, lineVertex, index + 1);
            BufferUtils.setInBuffer(tangentColor, lineColor, index + 1);
            if (binormalBuffer == null) {
                normal.cross(tangent, point);
                point.multLocal(-tangentW);
                point.normalizeLocal();
            } else {
                BufferUtils.populateFromBuffer(point, binormalBuffer, i);
            }
            point.multLocal(scale);
            point.addLocal(origin);
            BufferUtils.setInBuffer(point, lineVertex, index + 2);
            BufferUtils.setInBuffer(binormalColor, lineColor, index + 2);
            point.set(normal);
            point.multLocal(scale);
            point.addLocal(origin);
            BufferUtils.setInBuffer(point, lineVertex, index + 3);
            BufferUtils.setInBuffer(normalColor, lineColor, index + 3);
        }
        lineMesh.setBuffer(VertexBuffer.Type.Index, 1, lineIndex);
        lineMesh.setBuffer(VertexBuffer.Type.Position, 3, lineVertex);
        lineMesh.setBuffer(VertexBuffer.Type.Color, 4, lineColor);
        lineMesh.setStatic();
        return lineMesh;
    }

    static {
        TangentBinormalGenerator.setToleranceAngle(45.0f);
    }

    public static class TriangleData {
        public final Vector3f tangent;
        public final Vector3f binormal;
        public final Vector3f normal;

        public TriangleData(Vector3f tangent, Vector3f binormal, Vector3f normal) {
            this.tangent = tangent;
            this.binormal = binormal;
            this.normal = normal;
        }
    }

    private static class VertexData {
        public final ArrayList<TriangleData> triangles = new ArrayList();
    }

    private static class VertexInfo {
        public final Vector3f position;
        public final Vector3f normal;
        public final Vector2f texCoord;
        public final ArrayList<Integer> indices = new ArrayList();

        public VertexInfo(Vector3f position, Vector3f normal, Vector2f texCoord) {
            this.position = position;
            this.normal = normal;
            this.texCoord = texCoord;
        }
    }
}

