/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import com.jme3.asset.AssetManager;
import com.jme3.audio.AudioBuffer;
import com.jme3.audio.AudioData;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.texture.Image;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;

public class PlaceholderAssets {
    private static final byte[] imageData = new byte[]{-1, -1, -1, -1, 0, 0, -1, -1, -1, -1, 0, 0, -1, 0, 0, -1, -1, -1, -1, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, -1, -1, -1, -1, 0, 0, -1, 0, 0, -1, -1, -1, -1, 0, 0, -1, -1, -1};

    public static Image getPlaceholderImage() {
        ByteBuffer tempData = BufferUtils.createByteBuffer(48);
        tempData.put(imageData).flip();
        return new Image(Image.Format.RGB8, 4, 4, tempData);
    }

    public static Material getPlaceholderMaterial(AssetManager assetManager) {
        Material mat = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", ColorRGBA.Red);
        return mat;
    }

    public static Spatial getPlaceholderModel(AssetManager assetManager) {
        Box box = new Box(1.0f, 1.0f, 1.0f);
        Geometry geom = new Geometry("placeholder", box);
        geom.setMaterial(PlaceholderAssets.getPlaceholderMaterial(assetManager));
        return geom;
    }

    public static AudioData getPlaceholderAudio() {
        AudioBuffer audioBuf = new AudioBuffer();
        audioBuf.setupFormat(1, 8, 44100);
        ByteBuffer bb = BufferUtils.createByteBuffer(1);
        bb.put((byte)0).flip();
        audioBuf.updateData(bb);
        return audioBuf;
    }
}

