/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.FastMath;
import com.jme3.renderer.Renderer;
import com.jme3.util.BufferUtils;
import com.jme3.util.NativeObject;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class VertexBuffer
extends NativeObject
implements Savable,
Cloneable {
    protected int offset = 0;
    protected int lastLimit = 0;
    protected int stride = 0;
    protected int components = 0;
    protected transient int componentsLength = 0;
    protected Buffer data = null;
    protected Usage usage;
    protected Type bufType;
    protected Format format;
    protected boolean normalized = false;
    protected transient boolean dataSizeChanged = false;

    public VertexBuffer(Type type) {
        super(VertexBuffer.class);
        this.bufType = type;
    }

    public VertexBuffer() {
        super(VertexBuffer.class);
    }

    protected VertexBuffer(int id) {
        super(VertexBuffer.class, id);
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getStride() {
        return this.stride;
    }

    public void setStride(int stride) {
        this.stride = stride;
    }

    public Buffer getData() {
        return this.data;
    }

    public Buffer getDataReadOnly() {
        Buffer result;
        if (this.data == null) {
            return null;
        }
        if (this.data instanceof ByteBuffer) {
            result = ((ByteBuffer)this.data).asReadOnlyBuffer();
        } else if (this.data instanceof FloatBuffer) {
            result = ((FloatBuffer)this.data).asReadOnlyBuffer();
        } else if (this.data instanceof ShortBuffer) {
            result = ((ShortBuffer)this.data).asReadOnlyBuffer();
        } else if (this.data instanceof IntBuffer) {
            result = ((IntBuffer)this.data).asReadOnlyBuffer();
        } else {
            throw new UnsupportedOperationException("Cannot get read-only view of buffer type:" + this.data);
        }
        ((Buffer)result).rewind();
        return result;
    }

    public Usage getUsage() {
        return this.usage;
    }

    public void setUsage(Usage usage) {
        this.usage = usage;
    }

    public void setNormalized(boolean normalized) {
        this.normalized = normalized;
    }

    public boolean isNormalized() {
        return this.normalized;
    }

    public Type getBufferType() {
        return this.bufType;
    }

    public Format getFormat() {
        return this.format;
    }

    public int getNumComponents() {
        return this.components;
    }

    public int getNumElements() {
        int elements = this.data.capacity() / this.components;
        if (this.format == Format.Half) {
            elements /= 2;
        }
        return elements;
    }

    public void setupData(Usage usage, int components, Format format, Buffer data) {
        if (this.id != -1) {
            throw new UnsupportedOperationException("Data has already been sent. Cannot setupData again.");
        }
        if (usage == null || format == null || data == null) {
            throw new IllegalArgumentException("None of the arguments can be null");
        }
        if (data.isReadOnly()) {
            throw new IllegalArgumentException("VertexBuffer data cannot be read-only.");
        }
        if (components < 1 || components > 4) {
            throw new IllegalArgumentException("components must be between 1 and 4");
        }
        this.data = data;
        this.components = components;
        this.usage = usage;
        this.format = format;
        this.componentsLength = components * format.getComponentSize();
        this.lastLimit = data.limit();
        this.setUpdateNeeded();
    }

    public void updateData(Buffer data) {
        if (this.id != -1) {
            // empty if block
        }
        if (data != null && data.isReadOnly()) {
            throw new IllegalArgumentException("VertexBuffer data cannot be read-only.");
        }
        if (data != null && (this.data.getClass() != data.getClass() || data.limit() != this.lastLimit)) {
            this.dataSizeChanged = true;
            this.lastLimit = data.limit();
        }
        this.data = data;
        this.setUpdateNeeded();
    }

    public boolean hasDataSizeChanged() {
        return this.dataSizeChanged;
    }

    public void clearUpdateNeeded() {
        super.clearUpdateNeeded();
        this.dataSizeChanged = false;
    }

    public void convertToHalf() {
        if (this.id != -1) {
            throw new UnsupportedOperationException("Data has already been sent.");
        }
        if (this.format != Format.Float) {
            throw new IllegalStateException("Format must be float!");
        }
        int numElements = this.data.capacity() / this.components;
        this.format = Format.Half;
        this.componentsLength = this.components * this.format.getComponentSize();
        ByteBuffer halfData = BufferUtils.createByteBuffer(this.componentsLength * numElements);
        halfData.rewind();
        FloatBuffer floatData = (FloatBuffer)this.data;
        floatData.rewind();
        for (int i = 0; i < floatData.capacity(); ++i) {
            float f = floatData.get(i);
            short half = FastMath.convertFloatToHalf(f);
            halfData.putShort(half);
        }
        this.data = halfData;
        this.setUpdateNeeded();
        this.dataSizeChanged = true;
    }

    public void compact(int numElements) {
        int total = this.components * numElements;
        this.data.clear();
        switch (this.format) {
            case Byte: 
            case UnsignedByte: 
            case Half: {
                ByteBuffer bbuf = (ByteBuffer)this.data;
                bbuf.limit(total);
                ByteBuffer bnewBuf = BufferUtils.createByteBuffer(total);
                bnewBuf.put(bbuf);
                this.data = bnewBuf;
                break;
            }
            case Short: 
            case UnsignedShort: {
                ShortBuffer sbuf = (ShortBuffer)this.data;
                sbuf.limit(total);
                ShortBuffer snewBuf = BufferUtils.createShortBuffer(total);
                snewBuf.put(sbuf);
                this.data = snewBuf;
                break;
            }
            case Int: 
            case UnsignedInt: {
                IntBuffer ibuf = (IntBuffer)this.data;
                ibuf.limit(total);
                IntBuffer inewBuf = BufferUtils.createIntBuffer(total);
                inewBuf.put(ibuf);
                this.data = inewBuf;
                break;
            }
            case Float: {
                FloatBuffer fbuf = (FloatBuffer)this.data;
                fbuf.limit(total);
                FloatBuffer fnewBuf = BufferUtils.createFloatBuffer(total);
                fnewBuf.put(fbuf);
                this.data = fnewBuf;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unrecognized buffer format: " + (Object)((Object)this.format));
            }
        }
        this.data.clear();
        this.setUpdateNeeded();
        this.dataSizeChanged = true;
    }

    public void setElementComponent(int elementIndex, int componentIndex, Object val) {
        int inPos = elementIndex * this.components;
        int elementPos = componentIndex;
        if (this.format == Format.Half) {
            inPos *= 2;
            elementPos *= 2;
        }
        this.data.clear();
        switch (this.format) {
            case Byte: 
            case UnsignedByte: 
            case Half: {
                ByteBuffer bin = (ByteBuffer)this.data;
                bin.put(inPos + elementPos, (Byte)val);
                break;
            }
            case Short: 
            case UnsignedShort: {
                ShortBuffer sin = (ShortBuffer)this.data;
                sin.put(inPos + elementPos, (Short)val);
                break;
            }
            case Int: 
            case UnsignedInt: {
                IntBuffer iin = (IntBuffer)this.data;
                iin.put(inPos + elementPos, (Integer)val);
                break;
            }
            case Float: {
                FloatBuffer fin = (FloatBuffer)this.data;
                fin.put(inPos + elementPos, ((Float)val).floatValue());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unrecognized buffer format: " + (Object)((Object)this.format));
            }
        }
    }

    public Object getElementComponent(int elementIndex, int componentIndex) {
        int inPos = elementIndex * this.components;
        int elementPos = componentIndex;
        if (this.format == Format.Half) {
            inPos *= 2;
            elementPos *= 2;
        }
        Buffer srcData = this.getDataReadOnly();
        switch (this.format) {
            case Byte: 
            case UnsignedByte: 
            case Half: {
                ByteBuffer bin = (ByteBuffer)srcData;
                return bin.get(inPos + elementPos);
            }
            case Short: 
            case UnsignedShort: {
                ShortBuffer sin = (ShortBuffer)srcData;
                return sin.get(inPos + elementPos);
            }
            case Int: 
            case UnsignedInt: {
                IntBuffer iin = (IntBuffer)srcData;
                return iin.get(inPos + elementPos);
            }
            case Float: {
                FloatBuffer fin = (FloatBuffer)srcData;
                return Float.valueOf(fin.get(inPos + elementPos));
            }
        }
        throw new UnsupportedOperationException("Unrecognized buffer format: " + (Object)((Object)this.format));
    }

    public void copyElement(int inIndex, VertexBuffer outVb, int outIndex) {
        this.copyElements(inIndex, outVb, outIndex, 1);
    }

    public void copyElements(int inIndex, VertexBuffer outVb, int outIndex, int len) {
        if (outVb.format != this.format || outVb.components != this.components) {
            throw new IllegalArgumentException("Buffer format mismatch. Cannot copy");
        }
        int inPos = inIndex * this.components;
        int outPos = outIndex * this.components;
        int elementSz = this.components;
        if (this.format == Format.Half) {
            inPos *= 2;
            outPos *= 2;
            elementSz *= 2;
        }
        Buffer srcData = this.getDataReadOnly();
        outVb.data.clear();
        switch (this.format) {
            case Byte: 
            case UnsignedByte: 
            case Half: {
                ByteBuffer bin = (ByteBuffer)srcData;
                ByteBuffer bout = (ByteBuffer)outVb.data;
                bin.position(inPos).limit(inPos + elementSz * len);
                bout.position(outPos).limit(outPos + elementSz * len);
                bout.put(bin);
                break;
            }
            case Short: 
            case UnsignedShort: {
                ShortBuffer sin = (ShortBuffer)srcData;
                ShortBuffer sout = (ShortBuffer)outVb.data;
                sin.position(inPos).limit(inPos + elementSz * len);
                sout.position(outPos).limit(outPos + elementSz * len);
                sout.put(sin);
                break;
            }
            case Int: 
            case UnsignedInt: {
                IntBuffer iin = (IntBuffer)srcData;
                IntBuffer iout = (IntBuffer)outVb.data;
                iin.position(inPos).limit(inPos + elementSz * len);
                iout.position(outPos).limit(outPos + elementSz * len);
                iout.put(iin);
                break;
            }
            case Float: {
                FloatBuffer fin = (FloatBuffer)srcData;
                FloatBuffer fout = (FloatBuffer)outVb.data;
                fin.position(inPos).limit(inPos + elementSz * len);
                fout.position(outPos).limit(outPos + elementSz * len);
                fout.put(fin);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unrecognized buffer format: " + (Object)((Object)this.format));
            }
        }
        outVb.data.clear();
    }

    public static Buffer createBuffer(Format format, int components, int numElements) {
        if (components < 1 || components > 4) {
            throw new IllegalArgumentException("Num components must be between 1 and 4");
        }
        int total = numElements * components;
        switch (format) {
            case Byte: 
            case UnsignedByte: {
                return BufferUtils.createByteBuffer(total);
            }
            case Half: {
                return BufferUtils.createByteBuffer(total * 2);
            }
            case Short: 
            case UnsignedShort: {
                return BufferUtils.createShortBuffer(total);
            }
            case Int: 
            case UnsignedInt: {
                return BufferUtils.createIntBuffer(total);
            }
            case Float: {
                return BufferUtils.createFloatBuffer(total);
            }
            case Double: {
                return BufferUtils.createDoubleBuffer(total);
            }
        }
        throw new UnsupportedOperationException("Unrecoginized buffer format: " + (Object)((Object)format));
    }

    public VertexBuffer clone() {
        VertexBuffer vb = (VertexBuffer)super.clone();
        vb.handleRef = new Object();
        vb.id = -1;
        if (this.data != null) {
            vb.updateData(BufferUtils.clone(this.getDataReadOnly()));
        }
        return vb;
    }

    public VertexBuffer clone(Type overrideType) {
        VertexBuffer vb = new VertexBuffer(overrideType);
        vb.components = this.components;
        vb.componentsLength = this.componentsLength;
        vb.data = BufferUtils.clone(this.getDataReadOnly());
        vb.format = this.format;
        vb.handleRef = new Object();
        vb.id = -1;
        vb.normalized = this.normalized;
        vb.offset = this.offset;
        vb.stride = this.stride;
        vb.updateNeeded = true;
        vb.usage = this.usage;
        return vb;
    }

    public String toString() {
        String dataTxt = null;
        if (this.data != null) {
            dataTxt = ", elements=" + this.data.capacity();
        }
        return this.getClass().getSimpleName() + "[fmt=" + this.format.name() + ", type=" + this.bufType.name() + ", usage=" + this.usage.name() + dataTxt + "]";
    }

    public void resetObject() {
        this.id = -1;
        this.setUpdateNeeded();
    }

    public void deleteObject(Object rendererObject) {
        ((Renderer)rendererObject).deleteBuffer(this);
    }

    public NativeObject createDestructableClone() {
        return new VertexBuffer(this.id);
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.components, "components", 0);
        oc.write(this.usage, "usage", Usage.Dynamic);
        oc.write(this.bufType, "buffer_type", null);
        oc.write(this.format, "format", Format.Float);
        oc.write(this.normalized, "normalized", false);
        oc.write(this.offset, "offset", 0);
        oc.write(this.stride, "stride", 0);
        String dataName = "data" + this.format.name();
        Buffer roData = this.getDataReadOnly();
        switch (this.format) {
            case Float: {
                oc.write((FloatBuffer)roData, dataName, null);
                break;
            }
            case Short: 
            case UnsignedShort: {
                oc.write((ShortBuffer)roData, dataName, null);
                break;
            }
            case Byte: 
            case UnsignedByte: 
            case Half: {
                oc.write((ByteBuffer)roData, dataName, null);
                break;
            }
            case Int: 
            case UnsignedInt: {
                oc.write((IntBuffer)roData, dataName, null);
                break;
            }
            default: {
                throw new IOException("Unsupported export buffer format: " + (Object)((Object)this.format));
            }
        }
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.components = ic.readInt("components", 0);
        this.usage = ic.readEnum("usage", Usage.class, Usage.Dynamic);
        this.bufType = ic.readEnum("buffer_type", Type.class, null);
        this.format = ic.readEnum("format", Format.class, Format.Float);
        this.normalized = ic.readBoolean("normalized", false);
        this.offset = ic.readInt("offset", 0);
        this.stride = ic.readInt("stride", 0);
        this.componentsLength = this.components * this.format.getComponentSize();
        String dataName = "data" + this.format.name();
        switch (this.format) {
            case Float: {
                this.data = ic.readFloatBuffer(dataName, null);
                break;
            }
            case Short: 
            case UnsignedShort: {
                this.data = ic.readShortBuffer(dataName, null);
                break;
            }
            case Byte: 
            case UnsignedByte: 
            case Half: {
                this.data = ic.readByteBuffer(dataName, null);
                break;
            }
            case Int: 
            case UnsignedInt: {
                this.data = ic.readIntBuffer(dataName, null);
                break;
            }
            default: {
                throw new IOException("Unsupported import buffer format: " + (Object)((Object)this.format));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        Half(2),
        Float(4),
        Double(8),
        Byte(1),
        UnsignedByte(1),
        Short(2),
        UnsignedShort(2),
        Int(4),
        UnsignedInt(4);

        private int componentSize = 0;

        private Format(int componentSize) {
            this.componentSize = componentSize;
        }

        public int getComponentSize() {
            return this.componentSize;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        Position,
        Size,
        Normal,
        TexCoord,
        Color,
        Tangent,
        Binormal,
        InterleavedData,
        MiscAttrib,
        Index,
        BindPosePosition,
        BindPoseNormal,
        BoneWeight,
        BoneIndex,
        TexCoord2,
        TexCoord3,
        TexCoord4,
        TexCoord5,
        TexCoord6,
        TexCoord7,
        TexCoord8,
        BindPoseTangent;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Usage {
        Static,
        Dynamic,
        Stream,
        CpuOnly;

    }
}

