/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.export.binary;

import com.jme3.export.InputCapsule;
import com.jme3.export.Savable;
import com.jme3.export.SavableClassUtil;
import com.jme3.export.binary.BinaryClassField;
import com.jme3.export.binary.BinaryClassObject;
import com.jme3.export.binary.BinaryImporter;
import com.jme3.export.binary.ByteUtils;
import com.jme3.util.BufferUtils;
import com.jme3.util.IntMap;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BinaryInputCapsule
implements InputCapsule {
    private static final Logger logger = Logger.getLogger(BinaryInputCapsule.class.getName());
    protected BinaryImporter importer;
    protected BinaryClassObject cObj;
    protected Savable savable;
    protected HashMap<Byte, Object> fieldData;
    protected int index = 0;
    private static final int UTF8_START = 0;
    private static final int UTF8_2BYTE = 2;
    private static final int UTF8_3BYTE_1 = 3;
    private static final int UTF8_3BYTE_2 = 4;
    private static final int UTF8_ILLEGAL = 10;

    public BinaryInputCapsule(BinaryImporter importer, Savable savable, BinaryClassObject bco) {
        this.importer = importer;
        this.cObj = bco;
        this.savable = savable;
    }

    public void setContent(byte[] content, int start, int limit) {
        this.fieldData = new HashMap();
        this.index = start;
        block44: while (this.index < limit) {
            byte alias = content[this.index];
            ++this.index;
            try {
                byte type = this.cObj.aliasFields.get((Object)Byte.valueOf((byte)alias)).type;
                Object value = null;
                switch (type) {
                    case 80: {
                        value = this.readBitSet(content);
                        break;
                    }
                    case 60: {
                        value = this.readBoolean(content);
                        break;
                    }
                    case 61: {
                        value = this.readBooleanArray(content);
                        break;
                    }
                    case 62: {
                        value = this.readBooleanArray2D(content);
                        break;
                    }
                    case 0: {
                        value = this.readByte(content);
                        break;
                    }
                    case 1: {
                        value = this.readByteArray(content);
                        break;
                    }
                    case 2: {
                        value = this.readByteArray2D(content);
                        break;
                    }
                    case 122: {
                        value = this.readByteBuffer(content);
                        break;
                    }
                    case 30: {
                        value = this.readDouble(content);
                        break;
                    }
                    case 31: {
                        value = this.readDoubleArray(content);
                        break;
                    }
                    case 32: {
                        value = this.readDoubleArray2D(content);
                        break;
                    }
                    case 20: {
                        value = Float.valueOf(this.readFloat(content));
                        break;
                    }
                    case 21: {
                        value = this.readFloatArray(content);
                        break;
                    }
                    case 22: {
                        value = this.readFloatArray2D(content);
                        break;
                    }
                    case 120: {
                        value = this.readFloatBuffer(content);
                        break;
                    }
                    case 110: {
                        value = this.readFloatBufferArrayList(content);
                        break;
                    }
                    case 111: {
                        value = this.readByteBufferArrayList(content);
                        break;
                    }
                    case 10: {
                        value = this.readInt(content);
                        break;
                    }
                    case 11: {
                        value = this.readIntArray(content);
                        break;
                    }
                    case 12: {
                        value = this.readIntArray2D(content);
                        break;
                    }
                    case 121: {
                        value = this.readIntBuffer(content);
                        break;
                    }
                    case 40: {
                        value = this.readLong(content);
                        break;
                    }
                    case 41: {
                        value = this.readLongArray(content);
                        break;
                    }
                    case 42: {
                        value = this.readLongArray2D(content);
                        break;
                    }
                    case 90: {
                        value = this.readSavable(content);
                        break;
                    }
                    case 91: {
                        value = this.readSavableArray(content);
                        break;
                    }
                    case 92: {
                        value = this.readSavableArray2D(content);
                        break;
                    }
                    case 100: {
                        value = this.readSavableArray(content);
                        break;
                    }
                    case 101: {
                        value = this.readSavableArray2D(content);
                        break;
                    }
                    case 102: {
                        value = this.readSavableArray3D(content);
                        break;
                    }
                    case 105: {
                        value = this.readSavableMap(content);
                        break;
                    }
                    case 106: {
                        value = this.readStringSavableMap(content);
                        break;
                    }
                    case 107: {
                        value = this.readIntSavableMap(content);
                        break;
                    }
                    case 50: {
                        value = this.readShort(content);
                        break;
                    }
                    case 51: {
                        value = this.readShortArray(content);
                        break;
                    }
                    case 52: {
                        value = this.readShortArray2D(content);
                        break;
                    }
                    case 123: {
                        value = this.readShortBuffer(content);
                        break;
                    }
                    case 70: {
                        value = this.readString(content);
                        break;
                    }
                    case 71: {
                        value = this.readStringArray(content);
                        break;
                    }
                    case 72: {
                        value = this.readStringArray2D(content);
                        break;
                    }
                    default: {
                        continue block44;
                    }
                }
                this.fieldData.put(alias, value);
            }
            catch (IOException e) {
                logger.logp(Level.SEVERE, this.getClass().toString(), "setContent(byte[] content)", "Exception", e);
            }
        }
    }

    @Override
    public int getSavableVersion(Class<? extends Savable> desiredClass) {
        return SavableClassUtil.getSavedSavableVersion(this.savable, desiredClass, this.cObj.classHierarchyVersions, this.importer.getFormatVersion());
    }

    @Override
    public BitSet readBitSet(String name, BitSet defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (BitSet)this.fieldData.get(field.alias);
    }

    @Override
    public boolean readBoolean(String name, boolean defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (Boolean)this.fieldData.get(field.alias);
    }

    @Override
    public boolean[] readBooleanArray(String name, boolean[] defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (boolean[])this.fieldData.get(field.alias);
    }

    @Override
    public boolean[][] readBooleanArray2D(String name, boolean[][] defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (boolean[][])this.fieldData.get(field.alias);
    }

    @Override
    public byte readByte(String name, byte defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (Byte)this.fieldData.get(field.alias);
    }

    @Override
    public byte[] readByteArray(String name, byte[] defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (byte[])this.fieldData.get(field.alias);
    }

    @Override
    public byte[][] readByteArray2D(String name, byte[][] defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (byte[][])this.fieldData.get(field.alias);
    }

    @Override
    public ByteBuffer readByteBuffer(String name, ByteBuffer defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (ByteBuffer)this.fieldData.get(field.alias);
    }

    @Override
    public ArrayList<ByteBuffer> readByteBufferArrayList(String name, ArrayList<ByteBuffer> defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (ArrayList)this.fieldData.get(field.alias);
    }

    @Override
    public double readDouble(String name, double defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (Double)this.fieldData.get(field.alias);
    }

    @Override
    public double[] readDoubleArray(String name, double[] defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (double[])this.fieldData.get(field.alias);
    }

    @Override
    public double[][] readDoubleArray2D(String name, double[][] defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (double[][])this.fieldData.get(field.alias);
    }

    @Override
    public float readFloat(String name, float defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return ((Float)this.fieldData.get(field.alias)).floatValue();
    }

    @Override
    public float[] readFloatArray(String name, float[] defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (float[])this.fieldData.get(field.alias);
    }

    @Override
    public float[][] readFloatArray2D(String name, float[][] defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (float[][])this.fieldData.get(field.alias);
    }

    @Override
    public FloatBuffer readFloatBuffer(String name, FloatBuffer defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (FloatBuffer)this.fieldData.get(field.alias);
    }

    @Override
    public ArrayList<FloatBuffer> readFloatBufferArrayList(String name, ArrayList<FloatBuffer> defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (ArrayList)this.fieldData.get(field.alias);
    }

    @Override
    public int readInt(String name, int defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (Integer)this.fieldData.get(field.alias);
    }

    @Override
    public int[] readIntArray(String name, int[] defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (int[])this.fieldData.get(field.alias);
    }

    @Override
    public int[][] readIntArray2D(String name, int[][] defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (int[][])this.fieldData.get(field.alias);
    }

    @Override
    public IntBuffer readIntBuffer(String name, IntBuffer defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (IntBuffer)this.fieldData.get(field.alias);
    }

    @Override
    public long readLong(String name, long defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (Long)this.fieldData.get(field.alias);
    }

    @Override
    public long[] readLongArray(String name, long[] defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (long[])this.fieldData.get(field.alias);
    }

    @Override
    public long[][] readLongArray2D(String name, long[][] defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (long[][])this.fieldData.get(field.alias);
    }

    @Override
    public Savable readSavable(String name, Savable defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        Object value = this.fieldData.get(field.alias);
        if (value == null) {
            return null;
        }
        if (value instanceof ID) {
            value = this.importer.readObject(((ID)value).id);
            this.fieldData.put(field.alias, value);
            return (Savable)value;
        }
        return defVal;
    }

    @Override
    public Savable[] readSavableArray(String name, Savable[] defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        Object[] values = (Object[])this.fieldData.get(field.alias);
        if (values instanceof ID[]) {
            values = this.resolveIDs(values);
            this.fieldData.put(field.alias, values);
            return (Savable[])values;
        }
        return defVal;
    }

    private Savable[] resolveIDs(Object[] values) {
        if (values != null) {
            Savable[] savables = new Savable[values.length];
            for (int i = 0; i < values.length; ++i) {
                ID id = (ID)values[i];
                savables[i] = id != null ? this.importer.readObject(id.id) : null;
            }
            return savables;
        }
        return null;
    }

    @Override
    public Savable[][] readSavableArray2D(String name, Savable[][] defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        Object[][] values = (Object[][])this.fieldData.get(field.alias);
        if (values instanceof ID[][]) {
            Savable[][] savables = new Savable[values.length][];
            for (int i = 0; i < values.length; ++i) {
                savables[i] = values[i] != null ? this.resolveIDs(values[i]) : null;
            }
            values = savables;
            this.fieldData.put(field.alias, values);
        }
        return (Savable[][])values;
    }

    public Savable[][][] readSavableArray3D(String name, Savable[][][] defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        Object[][][] values = (Object[][][])this.fieldData.get(field.alias);
        if (values instanceof ID[][][]) {
            Savable[][][] savables = new Savable[values.length][][];
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != null) {
                    savables[i] = new Savable[values[i].length][];
                    for (int j = 0; j < values[i].length; ++j) {
                        savables[i][j] = this.resolveIDs(values[i][j]);
                    }
                    continue;
                }
                savables[i] = null;
            }
            this.fieldData.put(field.alias, savables);
            return savables;
        }
        return defVal;
    }

    private ArrayList<Savable> savableArrayListFromArray(Savable[] savables) {
        if (savables == null) {
            return null;
        }
        ArrayList<Savable> arrayList = new ArrayList<Savable>(savables.length);
        for (int x = 0; x < savables.length; ++x) {
            arrayList.add(savables[x]);
        }
        return arrayList;
    }

    private Map<Savable, Savable> savableMapFrom2DArray(Savable[][] savables) {
        if (savables == null) {
            return null;
        }
        HashMap<Savable, Savable> map = new HashMap<Savable, Savable>(savables.length);
        for (int x = 0; x < savables.length; ++x) {
            map.put(savables[x][0], savables[x][1]);
        }
        return map;
    }

    private Map<String, Savable> stringSavableMapFromKV(String[] keys, Savable[] values) {
        if (keys == null || values == null) {
            return null;
        }
        HashMap<String, Savable> map = new HashMap<String, Savable>(keys.length);
        for (int x = 0; x < keys.length; ++x) {
            map.put(keys[x], values[x]);
        }
        return map;
    }

    private IntMap<Savable> intSavableMapFromKV(int[] keys, Savable[] values) {
        if (keys == null || values == null) {
            return null;
        }
        IntMap<Savable> map = new IntMap<Savable>(keys.length);
        for (int x = 0; x < keys.length; ++x) {
            map.put(keys[x], values[x]);
        }
        return map;
    }

    @Override
    public ArrayList readSavableArrayList(String name, ArrayList defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        ArrayList<Savable> value = this.fieldData.get(field.alias);
        if (value instanceof ID[]) {
            Savable[] savables = this.readSavableArray(name, null);
            value = this.savableArrayListFromArray(savables);
            this.fieldData.put(field.alias, value);
        }
        return value;
    }

    @Override
    public ArrayList[] readSavableArrayListArray(String name, ArrayList[] defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        ArrayList[] value = this.fieldData.get(field.alias);
        if (value instanceof ID[][]) {
            Savable[][] savables = this.readSavableArray2D(name, null);
            if (savables != null) {
                ArrayList[] arrayLists = new ArrayList[savables.length];
                for (int i = 0; i < savables.length; ++i) {
                    arrayLists[i] = this.savableArrayListFromArray(savables[i]);
                }
                value = arrayLists;
            } else {
                value = defVal;
            }
            this.fieldData.put(field.alias, value);
        }
        return value;
    }

    @Override
    public ArrayList[][] readSavableArrayListArray2D(String name, ArrayList[][] defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        ArrayList[][] value = this.fieldData.get(field.alias);
        if (value instanceof ID[][][]) {
            Savable[][][] savables = this.readSavableArray3D(name, null);
            if (savables != null && savables.length > 0) {
                ArrayList[][] arrayLists = new ArrayList[savables.length][];
                for (int i = 0; i < savables.length; ++i) {
                    arrayLists[i] = new ArrayList[savables[i].length];
                    for (int j = 0; j < savables[i].length; ++j) {
                        arrayLists[i][j] = this.savableArrayListFromArray(savables[i][j]);
                    }
                }
                value = arrayLists;
            } else {
                value = defVal;
            }
            this.fieldData.put(field.alias, value);
        }
        return value;
    }

    @Override
    public Map<? extends Savable, ? extends Savable> readSavableMap(String name, Map<? extends Savable, ? extends Savable> defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        Map<Savable, Savable> value = this.fieldData.get(field.alias);
        if (value instanceof ID[][]) {
            Savable[][] savables = this.readSavableArray2D(name, null);
            value = this.savableMapFrom2DArray(savables);
            this.fieldData.put(field.alias, value);
        }
        return value;
    }

    @Override
    public Map<String, ? extends Savable> readStringSavableMap(String name, Map<String, ? extends Savable> defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        Map<String, Savable> value = this.fieldData.get(field.alias);
        if (value instanceof StringIDMap) {
            StringIDMap in = (StringIDMap)((Object)value);
            Savable[] values = this.resolveIDs(in.values);
            value = this.stringSavableMapFromKV(in.keys, values);
            this.fieldData.put(field.alias, value);
        }
        return value;
    }

    @Override
    public IntMap<? extends Savable> readIntSavableMap(String name, IntMap<? extends Savable> defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        IntMap<Savable> value = this.fieldData.get(field.alias);
        if (value instanceof IntIDMap) {
            IntIDMap in = (IntIDMap)((Object)value);
            Savable[] values = this.resolveIDs(in.values);
            value = this.intSavableMapFromKV(in.keys, values);
            this.fieldData.put(field.alias, value);
        }
        return value;
    }

    @Override
    public short readShort(String name, short defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (Short)this.fieldData.get(field.alias);
    }

    @Override
    public short[] readShortArray(String name, short[] defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (short[])this.fieldData.get(field.alias);
    }

    @Override
    public short[][] readShortArray2D(String name, short[][] defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (short[][])this.fieldData.get(field.alias);
    }

    @Override
    public ShortBuffer readShortBuffer(String name, ShortBuffer defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (ShortBuffer)this.fieldData.get(field.alias);
    }

    @Override
    public String readString(String name, String defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (String)this.fieldData.get(field.alias);
    }

    @Override
    public String[] readStringArray(String name, String[] defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (String[])this.fieldData.get(field.alias);
    }

    @Override
    public String[][] readStringArray2D(String name, String[][] defVal) throws IOException {
        BinaryClassField field = this.cObj.nameFields.get(name);
        if (field == null || !this.fieldData.containsKey(field.alias)) {
            return defVal;
        }
        return (String[][])this.fieldData.get(field.alias);
    }

    protected byte readByte(byte[] content) throws IOException {
        byte value = content[this.index];
        ++this.index;
        return value;
    }

    protected byte readByteForBuffer(byte[] content) throws IOException {
        byte value = content[this.index];
        ++this.index;
        return value;
    }

    protected byte[] readByteArray(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        byte[] value = new byte[length];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readByte(content);
        }
        return value;
    }

    protected byte[][] readByteArray2D(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        byte[][] value = new byte[length][];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readByteArray(content);
        }
        return value;
    }

    protected int readIntForBuffer(byte[] content) {
        int number = ((content[this.index + 3] & 0xFF) << 24) + ((content[this.index + 2] & 0xFF) << 16) + ((content[this.index + 1] & 0xFF) << 8) + (content[this.index] & 0xFF);
        this.index += 4;
        return number;
    }

    protected int readInt(byte[] content) throws IOException {
        byte[] bytes = BinaryInputCapsule.inflateFrom(content, this.index);
        this.index += 1 + bytes.length;
        int value = ByteUtils.convertIntFromBytes(bytes = ByteUtils.rightAlignBytes(bytes, 4));
        if (value == -1 || value == -2) {
            this.index -= 4;
        }
        return value;
    }

    protected int[] readIntArray(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        int[] value = new int[length];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readInt(content);
        }
        return value;
    }

    protected int[][] readIntArray2D(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        int[][] value = new int[length][];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readIntArray(content);
        }
        return value;
    }

    protected float readFloat(byte[] content) throws IOException {
        float value = ByteUtils.convertFloatFromBytes(content, this.index);
        this.index += 4;
        return value;
    }

    protected float readFloatForBuffer(byte[] content) throws IOException {
        int number = this.readIntForBuffer(content);
        return Float.intBitsToFloat(number);
    }

    protected float[] readFloatArray(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        float[] value = new float[length];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readFloat(content);
        }
        return value;
    }

    protected float[][] readFloatArray2D(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        float[][] value = new float[length][];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readFloatArray(content);
        }
        return value;
    }

    protected double readDouble(byte[] content) throws IOException {
        double value = ByteUtils.convertDoubleFromBytes(content, this.index);
        this.index += 8;
        return value;
    }

    protected double[] readDoubleArray(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        double[] value = new double[length];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readDouble(content);
        }
        return value;
    }

    protected double[][] readDoubleArray2D(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        double[][] value = new double[length][];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readDoubleArray(content);
        }
        return value;
    }

    protected long readLong(byte[] content) throws IOException {
        byte[] bytes = BinaryInputCapsule.inflateFrom(content, this.index);
        this.index += 1 + bytes.length;
        bytes = ByteUtils.rightAlignBytes(bytes, 8);
        long value = ByteUtils.convertLongFromBytes(bytes);
        return value;
    }

    protected long[] readLongArray(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        long[] value = new long[length];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readLong(content);
        }
        return value;
    }

    protected long[][] readLongArray2D(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        long[][] value = new long[length][];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readLongArray(content);
        }
        return value;
    }

    protected short readShort(byte[] content) throws IOException {
        short value = ByteUtils.convertShortFromBytes(content, this.index);
        this.index += 2;
        return value;
    }

    protected short readShortForBuffer(byte[] content) throws IOException {
        short number = (short)((content[this.index + 0] & 0xFF) + ((content[this.index + 1] & 0xFF) << 8));
        this.index += 2;
        return number;
    }

    protected short[] readShortArray(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        short[] value = new short[length];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readShort(content);
        }
        return value;
    }

    protected short[][] readShortArray2D(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        short[][] value = new short[length][];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readShortArray(content);
        }
        return value;
    }

    protected boolean readBoolean(byte[] content) throws IOException {
        boolean value = ByteUtils.convertBooleanFromBytes(content, this.index);
        ++this.index;
        return value;
    }

    protected boolean[] readBooleanArray(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        boolean[] value = new boolean[length];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readBoolean(content);
        }
        return value;
    }

    protected boolean[][] readBooleanArray2D(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        boolean[][] value = new boolean[length][];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readBooleanArray(content);
        }
        return value;
    }

    protected String readString(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        byte[] bytes = new byte[length];
        int utf8State = 0;
        block6: for (int x = 0; x < length; ++x) {
            bytes[x] = content[this.index++];
            int b = bytes[x] & 0xFF;
            switch (utf8State) {
                case 0: {
                    if (b < 128) continue block6;
                    if ((b & 0xC0) == 192) {
                        utf8State = 2;
                        continue block6;
                    }
                    if ((b & 0xE0) == 224) {
                        utf8State = 3;
                        continue block6;
                    }
                    utf8State = 10;
                    continue block6;
                }
                case 2: 
                case 3: 
                case 4: {
                    utf8State = (b & 0x80) == 128 ? (utf8State == 3 ? 4 : 0) : 10;
                }
            }
        }
        try {
            if (utf8State == 0) {
                return new String(bytes, "UTF8");
            }
            logger.log(Level.WARNING, "Your export has been saved with an incorrect encoding for it's String fields which means it might not load correctly due to encoding issues. You should probably re-export your work. See ISSUE 276 in the jME issue tracker.");
            return new String(bytes, "ISO8859_1");
        }
        catch (UnsupportedEncodingException uee) {
            logger.log(Level.SEVERE, "Your export has been saved with an incorrect encoding or your version of Java is unable to decode the stored string. While your export may load correctly by falling back, using it on different platforms or java versions might lead to very strange inconsitenties. You should probably re-export your work. See ISSUE 276 in the jME issue tracker.");
            return new String(bytes);
        }
    }

    protected String[] readStringArray(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        String[] value = new String[length];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readString(content);
        }
        return value;
    }

    protected String[][] readStringArray2D(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        String[][] value = new String[length][];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readStringArray(content);
        }
        return value;
    }

    protected BitSet readBitSet(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        BitSet value = new BitSet(length);
        for (int x = 0; x < length; ++x) {
            value.set(x, this.readBoolean(content));
        }
        return value;
    }

    protected static byte[] inflateFrom(byte[] contents, int index) {
        byte firstByte = contents[index];
        if (firstByte == -1) {
            return ByteUtils.convertToBytes(-1);
        }
        if (firstByte == -2) {
            return ByteUtils.convertToBytes(-2);
        }
        if (firstByte == 0) {
            return new byte[0];
        }
        byte[] rVal = new byte[firstByte];
        for (int x = 0; x < rVal.length; ++x) {
            rVal[x] = contents[x + 1 + index];
        }
        return rVal;
    }

    protected ID readSavable(byte[] content) throws IOException {
        int id = this.readInt(content);
        if (id == -1) {
            return null;
        }
        return new ID(id);
    }

    protected ID[] readSavableArray(byte[] content) throws IOException {
        int elements = this.readInt(content);
        if (elements == -1) {
            return null;
        }
        ID[] rVal = new ID[elements];
        for (int x = 0; x < elements; ++x) {
            rVal[x] = this.readSavable(content);
        }
        return rVal;
    }

    protected ID[][] readSavableArray2D(byte[] content) throws IOException {
        int elements = this.readInt(content);
        if (elements == -1) {
            return null;
        }
        ID[][] rVal = new ID[elements][];
        for (int x = 0; x < elements; ++x) {
            rVal[x] = this.readSavableArray(content);
        }
        return rVal;
    }

    protected ID[][][] readSavableArray3D(byte[] content) throws IOException {
        int elements = this.readInt(content);
        if (elements == -1) {
            return null;
        }
        ID[][][] rVal = new ID[elements][][];
        for (int x = 0; x < elements; ++x) {
            rVal[x] = this.readSavableArray2D(content);
        }
        return rVal;
    }

    protected ID[][] readSavableMap(byte[] content) throws IOException {
        int elements = this.readInt(content);
        if (elements == -1) {
            return null;
        }
        ID[][] rVal = new ID[elements][];
        for (int x = 0; x < elements; ++x) {
            rVal[x] = this.readSavableArray(content);
        }
        return rVal;
    }

    protected StringIDMap readStringSavableMap(byte[] content) throws IOException {
        int elements = this.readInt(content);
        if (elements == -1) {
            return null;
        }
        String[] keys = this.readStringArray(content);
        ID[] values = this.readSavableArray(content);
        StringIDMap rVal = new StringIDMap();
        rVal.keys = keys;
        rVal.values = values;
        return rVal;
    }

    protected IntIDMap readIntSavableMap(byte[] content) throws IOException {
        int elements = this.readInt(content);
        if (elements == -1) {
            return null;
        }
        int[] keys = this.readIntArray(content);
        ID[] values = this.readSavableArray(content);
        IntIDMap rVal = new IntIDMap();
        rVal.keys = keys;
        rVal.values = values;
        return rVal;
    }

    protected ArrayList<FloatBuffer> readFloatBufferArrayList(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        ArrayList<FloatBuffer> rVal = new ArrayList<FloatBuffer>(length);
        for (int x = 0; x < length; ++x) {
            rVal.add(this.readFloatBuffer(content));
        }
        return rVal;
    }

    protected ArrayList<ByteBuffer> readByteBufferArrayList(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        ArrayList<ByteBuffer> rVal = new ArrayList<ByteBuffer>(length);
        for (int x = 0; x < length; ++x) {
            rVal.add(this.readByteBuffer(content));
        }
        return rVal;
    }

    protected FloatBuffer readFloatBuffer(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        if (BinaryImporter.canUseFastBuffers()) {
            ByteBuffer value = BufferUtils.createByteBuffer(length * 4);
            value.put(content, this.index, length * 4).rewind();
            this.index += length * 4;
            return value.asFloatBuffer();
        }
        FloatBuffer value = BufferUtils.createFloatBuffer(length);
        for (int x = 0; x < length; ++x) {
            value.put(this.readFloatForBuffer(content));
        }
        value.rewind();
        return value;
    }

    protected IntBuffer readIntBuffer(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        if (BinaryImporter.canUseFastBuffers()) {
            ByteBuffer value = BufferUtils.createByteBuffer(length * 4);
            value.put(content, this.index, length * 4).rewind();
            this.index += length * 4;
            return value.asIntBuffer();
        }
        IntBuffer value = BufferUtils.createIntBuffer(length);
        for (int x = 0; x < length; ++x) {
            value.put(this.readIntForBuffer(content));
        }
        value.rewind();
        return value;
    }

    protected ByteBuffer readByteBuffer(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        if (BinaryImporter.canUseFastBuffers()) {
            ByteBuffer value = BufferUtils.createByteBuffer(length);
            value.put(content, this.index, length).rewind();
            this.index += length;
            return value;
        }
        ByteBuffer value = BufferUtils.createByteBuffer(length);
        for (int x = 0; x < length; ++x) {
            value.put(this.readByteForBuffer(content));
        }
        value.rewind();
        return value;
    }

    protected ShortBuffer readShortBuffer(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        if (BinaryImporter.canUseFastBuffers()) {
            ByteBuffer value = BufferUtils.createByteBuffer(length * 2);
            value.put(content, this.index, length * 2).rewind();
            this.index += length * 2;
            return value.asShortBuffer();
        }
        ShortBuffer value = BufferUtils.createShortBuffer(length);
        for (int x = 0; x < length; ++x) {
            value.put(this.readShortForBuffer(content));
        }
        value.rewind();
        return value;
    }

    @Override
    public <T extends Enum<T>> T readEnum(String name, Class<T> enumType, T defVal) throws IOException {
        String eVal = this.readString(name, defVal != null ? defVal.name() : null);
        if (eVal != null) {
            return Enum.valueOf(enumType, eVal);
        }
        return null;
    }

    private static class ID {
        public int id;

        public ID(int id) {
            this.id = id;
        }
    }

    private static class IntIDMap {
        public int[] keys;
        public ID[] values;

        private IntIDMap() {
        }
    }

    private static class StringIDMap {
        public String[] keys;
        public ID[] values;

        private StringIDMap() {
        }
    }
}

