/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.audio.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.audio.AudioBuffer;
import com.jme3.audio.AudioData;
import com.jme3.audio.AudioKey;
import com.jme3.audio.AudioStream;
import com.jme3.util.BufferUtils;
import com.jme3.util.LittleEndien;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WAVLoader
implements AssetLoader {
    private static final Logger logger = Logger.getLogger(WAVLoader.class.getName());
    private static final int i_RIFF = 1179011410;
    private static final int i_WAVE = 1163280727;
    private static final int i_fmt = 544501094;
    private static final int i_data = 1635017060;
    private boolean readStream = false;
    private AudioBuffer audioBuffer;
    private AudioStream audioStream;
    private AudioData audioData;
    private int bytesPerSec;
    private float duration;
    private LittleEndien in;

    private void readFormatChunk(int size) throws IOException {
        short compression = this.in.readShort();
        if (compression != 1) {
            throw new IOException("WAV Loader only supports PCM wave files");
        }
        short channels = this.in.readShort();
        int sampleRate = this.in.readInt();
        this.bytesPerSec = this.in.readInt();
        short bytesPerSample = this.in.readShort();
        short bitsPerSample = this.in.readShort();
        int expectedBytesPerSec = bitsPerSample * channels * sampleRate / 8;
        if (expectedBytesPerSec != this.bytesPerSec) {
            logger.log(Level.WARNING, "Expected {0} bytes per second, got {1}", new Object[]{expectedBytesPerSec, this.bytesPerSec});
        }
        if (bitsPerSample != 8 && bitsPerSample != 16) {
            throw new IOException("Only 8 and 16 bits per sample are supported!");
        }
        if (bitsPerSample / 8 * channels != bytesPerSample) {
            throw new IOException("Invalid bytes per sample value");
        }
        if (bytesPerSample * sampleRate != this.bytesPerSec) {
            throw new IOException("Invalid bytes per second value");
        }
        this.audioData.setupFormat(channels, bitsPerSample, sampleRate);
        int remaining = size - 16;
        if (remaining > 0) {
            this.in.skipBytes(remaining);
        }
    }

    private void readDataChunkForBuffer(int len) throws IOException {
        ByteBuffer data = BufferUtils.createByteBuffer(len);
        byte[] buf = new byte[512];
        int read = 0;
        while ((read = this.in.read(buf)) > 0) {
            data.put(buf, 0, Math.min(read, data.remaining()));
        }
        data.flip();
        this.audioBuffer.updateData(data);
        this.in.close();
    }

    private void readDataChunkForStream(int len) throws IOException {
        this.audioStream.updateData(this.in, this.duration);
    }

    private AudioData load(InputStream inputStream, boolean stream) throws IOException {
        this.in = new LittleEndien(inputStream);
        int sig = this.in.readInt();
        if (sig != 1179011410) {
            throw new IOException("File is not a WAVE file");
        }
        this.in.readInt();
        if (this.in.readInt() != 1163280727) {
            throw new IOException("WAVE File does not contain audio");
        }
        this.readStream = stream;
        if (this.readStream) {
            this.audioStream = new AudioStream();
            this.audioData = this.audioStream;
        } else {
            this.audioBuffer = new AudioBuffer();
            this.audioData = this.audioBuffer;
        }
        block4: while (true) {
            int type = this.in.readInt();
            int len = this.in.readInt();
            switch (type) {
                case 544501094: {
                    this.readFormatChunk(len);
                    continue block4;
                }
                case 1635017060: {
                    this.duration = len / this.bytesPerSec;
                    if (this.readStream) {
                        this.readDataChunkForStream(len);
                    } else {
                        this.readDataChunkForBuffer(len);
                    }
                    return this.audioData;
                }
            }
            int skipped = this.in.skipBytes(len);
            if (skipped <= 0) break;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(AssetInfo info) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = info.openStream();
            AudioData data = this.load(inputStream, ((AudioKey)info.getKey()).isStream());
            if (data instanceof AudioStream) {
                inputStream = null;
            }
            AudioData audioData = data;
            return audioData;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

