/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset.cache;

import com.jme3.asset.AssetKey;
import com.jme3.asset.CloneableSmartAsset;
import com.jme3.asset.cache.AssetCache;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakRefCloneAssetCache
implements AssetCache {
    private final WeakHashMap<AssetKey, SmartCachedAsset> smartCache = new WeakHashMap();
    private final ThreadLocal<ArrayDeque<AssetKey>> assetLoadStack = new ThreadLocal<ArrayDeque<AssetKey>>(){

        @Override
        protected ArrayDeque<AssetKey> initialValue() {
            return new ArrayDeque<AssetKey>();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void addToCache(AssetKey<T> key, T obj) {
        CloneableSmartAsset asset = (CloneableSmartAsset)obj;
        asset.setKey(null);
        WeakHashMap<AssetKey, SmartCachedAsset> weakHashMap = this.smartCache;
        synchronized (weakHashMap) {
            this.smartCache.put(key, new SmartCachedAsset(asset, key));
        }
        ArrayDeque<AssetKey> loadStack = this.assetLoadStack.get();
        loadStack.push(key);
    }

    @Override
    public <T> void registerAssetClone(AssetKey<T> key, T clone) {
        ArrayDeque<AssetKey> loadStack = this.assetLoadStack.get();
        ((CloneableSmartAsset)clone).setKey(loadStack.pop());
    }

    @Override
    public void notifyNoAssetClone() {
        ArrayDeque<AssetKey> loadStack = this.assetLoadStack.get();
        loadStack.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getFromCache(AssetKey<T> key) {
        SmartCachedAsset smartInfo;
        WeakHashMap<AssetKey, SmartCachedAsset> weakHashMap = this.smartCache;
        synchronized (weakHashMap) {
            smartInfo = this.smartCache.get(key);
        }
        if (smartInfo == null) {
            return null;
        }
        AssetKey keyForTheClone = (AssetKey)smartInfo.key.get();
        if (keyForTheClone == null) {
            return null;
        }
        ArrayDeque<AssetKey> loadStack = this.assetLoadStack.get();
        loadStack.push(keyForTheClone);
        return (T)smartInfo.asset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteFromCache(AssetKey key) {
        ArrayDeque<AssetKey> loadStack = this.assetLoadStack.get();
        if (!loadStack.isEmpty()) {
            throw new UnsupportedOperationException("Cache cannot be modifiedwhile assets are being loaded");
        }
        WeakHashMap<AssetKey, SmartCachedAsset> weakHashMap = this.smartCache;
        synchronized (weakHashMap) {
            return this.smartCache.remove(key) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        ArrayDeque<AssetKey> loadStack = this.assetLoadStack.get();
        if (!loadStack.isEmpty()) {
            throw new UnsupportedOperationException("Cache cannot be modifiedwhile assets are being loaded");
        }
        WeakHashMap<AssetKey, SmartCachedAsset> weakHashMap = this.smartCache;
        synchronized (weakHashMap) {
            this.smartCache.clear();
        }
    }

    private static final class SmartCachedAsset {
        WeakReference<AssetKey> key;
        CloneableSmartAsset asset;

        public SmartCachedAsset(CloneableSmartAsset originalAsset, AssetKey originalKey) {
            this.key = new WeakReference<AssetKey>(originalKey);
            this.asset = originalAsset;
        }
    }
}

