/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app;

import com.jme3.asset.AssetManager;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Statistics;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;

public class StatsView
extends Node
implements Control {
    private BitmapText[] labels;
    private Statistics statistics;
    private String[] statLabels;
    private int[] statData;
    private boolean enabled = true;
    private final StringBuilder stringBuilder = new StringBuilder();

    public StatsView(String name, AssetManager manager, Statistics stats) {
        super(name);
        this.setQueueBucket(RenderQueue.Bucket.Gui);
        this.setCullHint(Spatial.CullHint.Never);
        this.statistics = stats;
        this.statLabels = this.statistics.getLabels();
        this.statData = new int[this.statLabels.length];
        this.labels = new BitmapText[this.statLabels.length];
        BitmapFont font = manager.loadFont("Interface/Fonts/Console.fnt");
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i] = new BitmapText(font);
            this.labels[i].setLocalTranslation(0.0f, this.labels[i].getLineHeight() * (float)(i + 1), 0.0f);
            this.attachChild(this.labels[i]);
        }
        this.addControl(this);
    }

    public void update(float tpf) {
        if (!this.isEnabled()) {
            return;
        }
        this.statistics.getData(this.statData);
        for (int i = 0; i < this.labels.length; ++i) {
            this.stringBuilder.setLength(0);
            this.stringBuilder.append(this.statLabels[i]).append(" = ").append(this.statData[i]);
            this.labels[i].setText(this.stringBuilder);
        }
    }

    public Control cloneForSpatial(Spatial spatial) {
        return (Control)((Object)spatial);
    }

    public void setSpatial(Spatial spatial) {
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void render(RenderManager rm, ViewPort vp) {
    }
}

