#version 150
#extension GL_ARB_explicit_attrib_location : enable

uniform sampler2D Color;

//Color grading LUT
uniform sampler3D Tex3D0;

out vec4 outColor;
in vec2 UV;


layout (std140) uniform ToneMappingParams
{
float a;
float b;
float c;
float d;
float averageLuminance;
};

vec3 ToneMapTwo(vec3 x)
{
	vec3 a = vec3(a); /// Mid
	vec3 b = vec3(b); /// Toe
	vec3 c = vec3(c); /// Shoulder
	vec3 d = vec3(d); /// Mid

	return (x * (a * x + b)) / (x * (a * x + c) + d);
}

void main()
{
	float t = pow(2.0f,averageLuminance);
	vec3 texColor = (vec3(0.0001f)+texture2D(Color, UV).rgb)*t;
	vec3 curr = texColor;
	curr = ToneMapTwo(texColor);

	vec3 gammaCorrectedColor = pow(curr,vec3(1/2.2f));

	vec3 gradedColor = texture(Tex3D0, gammaCorrectedColor).rgb;
	outColor = vec4(gradedColor, 1.0);
}