#version 150
#extension GL_ARB_explicit_attrib_location : enable
layout( points ) in;
layout( triangle_strip, max_vertices = 4 ) out;

uniform float halfSize;
//uniform mat4 pMat;
//uniform mat4 mMat;
uniform mat3 mvMat;
uniform mat4 mvpMat;

out vec2 TexCoord;

in vec3 attribs[1];
in vec3 velocity[1];

out float intensity;

const float Epsilon = 0.0000001;

void main()
{
	if(attribs[0].x == 0.0f) return;
	intensity = attribs[0].y;

    vec3 u = mvMat * velocity[0];
    float w = halfSize;
    float h = w * 2.0;

    float t = 0.0;
    float nz = abs(normalize(u).z);
    if (nz > 1.0 - Epsilon)
        t = (nz - (1.0 - Epsilon)) / Epsilon;
    else if (dot(u,u) < Epsilon)
        t = (Epsilon - dot(u,u)) / Epsilon;

    u.z = 0.0;
    u = normalize(u);

    u = normalize(mix(u, vec3(1,0,0), t));
    h = mix(h, w, t);

    vec3 v = vec3(-u.y, u.x, 0);
    vec3 a = u * mvMat;
    vec3 b = v * mvMat;
    vec3 c = cross(a, b);
    mat3 basis = mat3(a, b, c);

    vec3 N = basis * vec3(0,w,0);
    vec3 S = basis * vec3(0,-w,0);
    vec3 E = basis * vec3(-h,0,0);//*vec3(1.5f);;
    vec3 W = basis * vec3(h,0,0);//*vec3(1.5f);;
    
    vec3 p = gl_in[0].gl_Position.xyz;
    //gAlpha = vAlpha[0];
    TexCoord = vec2(0,0);
	gl_Position = mvpMat * vec4(p+N+W,1); 
	EmitVertex();
    TexCoord = vec2(1,0);
	gl_Position = mvpMat * vec4(p+N+E,1);
	EmitVertex();
    TexCoord = vec2(0,1);
	gl_Position = mvpMat * vec4(p+S+W,1);
	EmitVertex();
    TexCoord = vec2(1,1);
	gl_Position = mvpMat * vec4(p+S+E,1);
	EmitVertex();
    EndPrimitive();
}


/*
void main()
{
if(attribs[0].x == 0.0f) return;
intensity = attribs[0].y;

mat4 m = pMat;
gl_Position = m * (vec4(-halfSize,-halfSize,0.0,0.0) + gl_in[0].gl_Position);
TexCoord = vec2(0.0,0.0);
EmitVertex();
gl_Position = m * (vec4(halfSize,-halfSize,0.0,0.0) + gl_in[0].gl_Position);
TexCoord = vec2(1.0,0.0);
EmitVertex();
gl_Position = m * (vec4(-halfSize,halfSize,0.0,0.0) + gl_in[0].gl_Position);
TexCoord = vec2(0.0,1.0);
EmitVertex();
gl_Position = m * (vec4(halfSize,halfSize,0.0,0.0) + gl_in[0].gl_Position);
TexCoord = vec2(1.0,1.0);
EmitVertex();

EndPrimitive();
}
*/