#version 150
#extension GL_ARB_explicit_attrib_location : enable
layout( points ) in;
layout( triangle_strip, max_vertices = 32 ) out;

struct LightInfo
{
	vec3 position;
	vec3 color;
};
LightInfo LightOne;

const float halfSize = 2;
uniform mat4 pMat;
uniform mat4 cMat;
uniform mat4 iMat;
out vec2 TexCoord;

out vec3 colOut;

void main()
{
vec4 lightPos = vec4(-5, 5.0, 12, 1.0);
vec4 lightPosCamera = cMat * lightPos;

//Vis Light
{
vec4 light[4];
const float lightSize = 0.50;
light[0] = vec4(-lightSize,-lightSize,0.0,0.0) + lightPosCamera;
light[1] = vec4(lightSize,-lightSize,0.0,0.0) + lightPosCamera;
light[2] = vec4(-lightSize,lightSize,0.0,0.0) + lightPosCamera;
light[3] = vec4(lightSize,lightSize,0.0,0.0) + lightPosCamera;
for(int i=0 ;i<4 ; i++) light[i] = pMat * light[i];
colOut = vec3(0.0, 1.0, 1.0);
gl_Position = light[0];
EmitVertex();
gl_Position = light[1];
EmitVertex();
gl_Position = light[2];
EmitVertex();
gl_Position = light[3];
EmitVertex();
EndPrimitive();
}


vec4 testPos = vec4(-15,3.0,25,1.0);
vec4 testPosTwo = vec4(-15,-40.0,25,1.0);

vec4 volume[4];
vec4 exVolume[4];

volume[0] = vec4(-halfSize,0.0,-halfSize,1.0) + testPosTwo;
volume[1] = vec4(halfSize,0.0,-halfSize,1.0) + testPosTwo;
volume[2] = vec4(-halfSize,0.0,halfSize,1.0) + testPosTwo;
volume[3] = vec4(halfSize,0.0,halfSize,1.0) + testPosTwo;

exVolume[0] = vec4(-halfSize,0.0,-halfSize,1.0) + testPosTwo;
exVolume[1] = vec4(halfSize,0.0,-halfSize,1.0) + testPosTwo;
exVolume[2] = vec4(-halfSize,0.0,halfSize,1.0) + testPosTwo;
exVolume[3] = vec4(halfSize,0.0,halfSize,1.0) + testPosTwo;

//Visible?
vec3 norm = cross( volume[1].xyz - volume[0].xyz, volume[2].xyz - volume[0].xyz);
vec3 lightDir = lightPos.xyz - volume[0].xyz;
if( dot(norm, lightDir) < 0.0f ) colOut = vec3(0,1,0); //Visible
else colOut = vec3(1,0,0); //Not




/*
const float ext = 120.0f;
for(int i=0 ; i<4 ; i++)
{
	exVolume[i] = volume[i];
	exVolume[i].y -= 40.0;
}
*/
mat4 vpMat = pMat * cMat;
for(int i=0 ;i<4 ; i++) volume[i] = vpMat * volume[i];
for(int i=0 ;i<4 ; i++) exVolume[i] = vpMat * exVolume[i];

//for(int i=0 ;i<4 ; i++) volume[i] = pMat * volume[i];
//for(int i=0 ;i<4 ; i++) exVolume[i] = pMat * exVolume[i];


//Front cap
gl_Position = volume[0];
EmitVertex();
gl_Position = volume[1];
EmitVertex();
gl_Position = volume[2];
EmitVertex();
gl_Position = volume[3];
EmitVertex();
EndPrimitive();


//Back cap
colOut = vec3(1,0,1);
gl_Position = exVolume[0];
EmitVertex();
gl_Position = exVolume[1];
EmitVertex();
gl_Position = exVolume[2];
EmitVertex();
gl_Position = exVolume[3];
EmitVertex();
EndPrimitive();

/*
colOut = vec3(0.1,0,0.1);

//Back
colOut = vec3(0.1,0,0.1);
gl_Position = volume[0];
EmitVertex();
gl_Position = volume[1];
EmitVertex();
gl_Position = exVolume[0];
EmitVertex();
gl_Position = exVolume[1];
EmitVertex();
EndPrimitive();

//Front
gl_Position = volume[2];
EmitVertex();
gl_Position = volume[3];
EmitVertex();
gl_Position = exVolume[2];
EmitVertex();
gl_Position = exVolume[3];
EmitVertex();
EndPrimitive();


//Left
gl_Position = volume[0];
EmitVertex();
gl_Position = volume[2];
EmitVertex();
gl_Position = exVolume[0];
EmitVertex();
gl_Position = exVolume[2];
EmitVertex();
EndPrimitive();

//Right
gl_Position = volume[1];
EmitVertex();
gl_Position = volume[3];
EmitVertex();
gl_Position = exVolume[1];
EmitVertex();
gl_Position = exVolume[3];
EmitVertex();
EndPrimitive();
*/


}