#version 150
#extension GL_ARB_explicit_attrib_location : enable

in vec3 gSpine;

out vec4 outColor;

uniform sampler2D Depth;
uniform sampler2D TexStroke;

uniform float angleShading;
uniform vec3 edgeColour;

in float edgeType;
in float angle;

in float gDist;
uniform float edgeWidth;

uniform float depthOffset;

void main(void)
{
    vec2 texCoord = (gSpine.xy + 1.0) / 2.0;
    float depth = texture2D(Depth, texCoord).r;
	depth += depthOffset;
	if (depth < gl_FragCoord.z)
        discard;

		
	float alpha = 1.0;
    float d = abs(gDist);
    float tipLength = 1.2 * fwidth(d);
    if (d > edgeWidth - tipLength)
    alpha = 1.0 - (d - edgeWidth + tipLength) / tipLength;
	
	vec3 color = edgeColour;
	float Gamma = 2.2f;
	color = pow(color.xyz, vec3(Gamma));

    outColor = vec4(color, alpha);
}