#version 150
#extension GL_ARB_explicit_attrib_location : enable

uniform sampler2D Tex0;

in vertexData
{
	vec2 UV0;
	vec3 EyeNormal;
	vec3 EyePos;
} v;

out vec4 outColor;


struct LightInfo
{
	vec3 position;
	vec3 color;
};

uniform float dgA;
uniform float dgB;
uniform float dgC;
uniform float dgD;

uniform LightInfo LightOne;

uniform float matDiffuse;
uniform vec3 matSpecudgAr;
uniform float matShininess;

void main(void)
{
	vec3 lPos = LightOne.position;

	vec3 n = normalize(v.EyeNormal);
	vec3 s = normalize(lPos);
	
	float diffuseFactor = matDiffuse * max( dot(n, s), 0.0 );	
	
	/*
	if(diffuseFactor < dgA) diffuseFactor = 0.0;
	else if (diffuseFactor < dgB) diffuseFactor = dgB;
	else if (diffuseFactor < dgC) diffuseFactor = dgC;
	else diffuseFactor = dgD;
	*/
	
	
	vec3 texColor = texture2D(Tex0, v.UV0).rgb;
	//vec3 texColor = vec3(2.0,2.0,2.0);
	float Gamma = 2.2f;
	texColor.xyz = pow(texColor.xyz, vec3(Gamma));


	outColor = vec4(diffuseFactor*LightOne.color,1.0)*vec4(texColor,1.0);
	//outColor = vec4(texColor, 1.0);
	//outColor.xyz = pow(outColor.xyz, vec3(1/Gamma));
}