#pragma OPENCL EXTENSION cl_amd_printf : enable

__kernel void SpawnParticles(__global float4 *positions, __global float4 *velocities, __global float4 *attributes, __global float4* spawnPositions, __global float4* spawnVelocities, __global float4* spawnAttributes, int workLimit, int segmentEnd, int segmentLength)
{
	if(get_global_id(0) < workLimit)
	{
		uint index = get_global_id(0);
		if(index >= segmentEnd) index -= segmentLength;

		if(attributes[index].x < 0.0001f)
		{
			positions[index] = spawnPositions[index];
			velocities[index] = spawnVelocities[index];
			//TODO: mark segment?
			attributes[index] = spawnAttributes[index];
		}
	}
	else return;
}