#pragma OPENCL EXTENSION cl_amd_printf : enable

float PackToFloat(unsigned int x, unsigned int y, unsigned int z)
{
	unsigned int packedColor = (x << 16) | (y << 8) | z;
	float packedFloat = (float) ( ((float)packedColor) / ((float) (1 << 24)) );  

	return packedFloat;
}

__kernel void SetSizeColorTrails(__global float4 *positions, __global float4 *velocities, __global float4 *attributes, __global float4 *forces, float deltaTime, float4 maxLife, float4 limiter, int workLimit, int segmentEnd, int segmentLength)
{
	if(get_global_id(0) < workLimit)
	{
		uint index = get_global_id(0);
		if(index >= segmentEnd) index -= segmentLength;
		//convert_uint(230-((attributes[index].x/20.0f)*255))
		positions[index] = positions[index];
		positions[index].w = PackToFloat(convert_uint(attributes[index].y*255), convert_uint(240-((attributes[index].x/20.0f)*220)), 0);
	}
	else return;
}