__kernel void IntegrateVerlet(__global float4 *curPositions, __global float4 *oldPositions, __global float4 *forces, float timeStep)
{
	uint index = get_global_id(0);

	float3 x = curPositions[index].xyz;
	float3 temp = curPositions[index].xyz;
	float3 oldX = oldPositions[index].xyz;
	float3 a = forces[index].xyz;

	curPositions[index].xyz += x-oldX+a*timeStep*timeStep;
	oldPositions[index].xyz = temp;
}