__kernel void SatisfyConstraintsVerlet(__global float4 *positions, __global float4 *constraints)
{
	uint index = get_global_id(0);

	if(constraints[index].w < 0.0) return;
	else
	{
	float4 constraint = constraints[index];
	float3 x1 = positions[convert_uint(constraint.x)].xyz;
	float3 x2 = positions[convert_uint(constraint.y)].xyz;
	float3 delta = x2-x1;
	float deltalength = length(delta);
	float diff=(deltalength-constraint.z)/deltalength;
	barrier(CLK_GLOBAL_MEM_FENCE);
	positions[convert_uint(constraint.x)].xyz += delta*0.5*diff;
	positions[convert_uint(constraint.y)].xyz -= delta*0.5*diff;

	/*
	//Constaint two
	x1 = positions[convert_uint(constraint.x)].xyz;
	x2 = positions[convert_uint(constraint.y)+1].xyz;
	delta = x2-x1;
	deltalength = length(delta);
	float goodLength = sqrt(constraint.z*constraint.z + constraint.z*constraint.z - 2*constraint.z*constraint.z*cos(1.785));
	if(goodLength > deltalength) diff=(deltalength-goodLength)/deltalength;
	else diff = 0;
	barrier(CLK_GLOBAL_MEM_FENCE);
	positions[convert_uint(constraint.x)].xyz += delta*0.5*diff;
	positions[convert_uint(constraint.y)+1].xyz -= delta*0.5*diff;
	*/
	}
}