#pragma OPENCL EXTENSION cl_amd_printf : enable

float PackToFloat(unsigned int x, unsigned int y, unsigned int z)
{
	unsigned int packedColor = (x << 16) | (y << 8) | z;
	float packedFloat = (float) ( ((double)packedColor) / ((double) (1 << 24)) );  

	return packedFloat;
}

__kernel void UpdatePositions(__global float4 *positions, __global float4 *velocities, __global float4 *attributes,__global float4 *forces, __global float4 *spawnPositions, __global float4 *spawnVelocities, __global float4 *spawnAttributes, float deltaTime, float4 limiter)
{
	uint index = get_global_id(0);
	
	//if(index == 0) printf("T: %v4f\n", attributes[0]);
	//Send particle offscreen if it's dead
	if(attributes[index].x < 0.01f)
	{
		positions[index] = (float4)(-999.0, -999.0, -999.0, 1.0);
	}
	else
	{
	//Velocities
	float4 oldVel = velocities[index];
	if(positions[index].x < limiter.x) velocities[index] += forces[index]*deltaTime;

	//Midpoint integration
	positions[index].xyz += 0.5*(oldVel.xyz+velocities[index].xyz)*deltaTime;
	positions[index].w = PackToFloat(convert_uint(attributes[index].y*255), convert_uint(240-((attributes[index].x/20.0f)*220)), 0);

	//Life
	attributes[index].x -= deltaTime;
	//if(attributes[index].x < 0.0001) positions[index] = (float4)(-999.0, -999.0, -999.0, 1.0);
	}
}