float4x4 matView : VIEW;
float4x4 matWorldView : WORLDVIEW;
float4x4 matWorldViewProjection : WORLDVIEWPROJECTION;
float4x4 matWorldViewInverse : WORLDVIEWINVERSE;
float time1, time2;
float freq1, freq2;
float amt1, amt2;
float fade;
float env_fade;
float desaturate;

textureCUBE env_tex;
samplerCUBE env_samp = sampler_state {
	Texture = (env_tex);
	MipFilter = LINEAR;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	sRGBTexture = TRUE;
};

textureCUBE env2_tex;
samplerCUBE env2_samp = sampler_state {
	Texture = (env2_tex);
	MipFilter = LINEAR;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	sRGBTexture = TRUE;
};

textureCUBE cube_noise_tex;
samplerCUBE noise_samp = sampler_state {
	Texture = (cube_noise_tex);
	MipFilter = LINEAR;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	sRGBTexture = FALSE;
};

texture foppall_tex;
sampler foppall_samp = sampler_state {
	Texture = (foppall_tex);
	MipFilter = NONE;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	AddressU = WRAP;
	AddressV = WRAP;
	sRGBTexture = TRUE;
};

struct VS_INPUT {
	float4 Position : POSITION0;
	float3 Normal : NORMAL;
};

struct VS_OUTPUT {
	float4 Position : POSITION0;
	float3 Pos2 : TEXCOORD2;
	float3 Pos3 : TEXCOORD3;
};

VS_OUTPUT vs_main( VS_INPUT Input )
{
	VS_OUTPUT Output;

	float3 pos = Input.Position;
	float3 opos = pos;
	Output.Position = mul( float4(pos, 1), matWorldViewProjection );
	Output.Pos2 = mul( float4(pos, 1), matWorldView );
	Output.Pos3 = normalize(Input.Position);
	return Output;
}

struct PS_OUTPUT {
	float4 col : COLOR0;
	float4 z : COLOR1;
};

PS_OUTPUT ps_main(VS_OUTPUT Input)
{
	float2 uv = float2(atan2(Input.Pos3.x, Input.Pos3.y) / (2.0 * 3.1415926) + 0.5, acos(Input.Pos3.z) / 3.1415926);
	PS_OUTPUT o;
	o.col = tex2D(foppall_samp, uv) * 0.5;
	o.z = Input.Pos2.z;
	return o;
}

technique cube_room {
	pass P0 {
		VertexShader = compile vs_3_0 vs_main();
		PixelShader  = compile ps_3_0 ps_main();
	}
}
