const float scroll;
const float time;

texture color_tex;
sampler color_samp = sampler_state {
	Texture = (color_tex);
	MipFilter = NONE;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	AddressU = CLAMP;
	AddressV = CLAMP;
	sRGBTexture = FALSE;
};

texture scroller_tex;
sampler scroller_samp = sampler_state {
	Texture = (scroller_tex);
	MipFilter = NONE;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	AddressU = CLAMP;
	AddressV = CLAMP;
	sRGBTexture = TRUE;
};

texture denmark_tex;
sampler denmark_samp = sampler_state {
	Texture = (denmark_tex);
	MipFilter = NONE;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	AddressU = CLAMP;
	AddressV = CLAMP;
	sRGBTexture = TRUE;
};

texture norway_tex;
sampler norway_samp = sampler_state {
	Texture = (norway_tex);
	MipFilter = NONE;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	AddressU = CLAMP;
	AddressV = CLAMP;
	sRGBTexture = TRUE;
};

struct VS_OUTPUT {
	float4 pos : POSITION;
	float4 uv  : TEXCOORD0;
//	float2 uv2 : TEXCOORD1;
};

VS_OUTPUT vertex(float4 ipos : POSITION, float2 uv : TEXCOORD0)
{
	VS_OUTPUT Out;
	Out.pos = ipos;
	Out.uv = uv.xyxy;
//	Out.uv2 = uv;
	return Out;
}

float4 pixel(VS_OUTPUT In) : COLOR
{
	float phase1 = In.uv.x * 40 + In.uv.y * 5 - time;
	float2 uv2 = In.uv.xy * 3.0 + float2(sin(phase1) * 0.025 - 0.25, cos(phase1) * 0.01 - 0.25);
	float phase2 = In.uv.x * 40 + In.uv.y * 5 - time;
	float2 uv3 = In.uv.xy * 3.0 + float2(sin(phase2) * 0.025 - 1.75, cos(phase2) * 0.01 - 0.25);
	float4 flag1 = tex2D(denmark_samp, uv2);
	flag1.rgb *= flag1.a;
	float4 flag2 = tex2D(norway_samp, uv3);
	flag2.rgb *= flag2.a;
	float4 col = tex2D(color_samp, In.uv.xy) * min(time * 0.05, 1.0);
	float4 flags = (flag1 + flag2) * min(time * 0.1, 1.0);
	col = lerp(col, flags, 0.25);
	col += tex2D(scroller_samp, In.uv.xy * float2(1, (1280.0 / 2880) / (16.0 / 9)) + float2(0, scroll));
	return col;
}

technique postprocess {
	pass P0 {
		VertexShader = compile vs_3_0 vertex();
		PixelShader  = compile ps_3_0 pixel();
	}
}
