uniform sampler2D PosTex, NormalTex;

uniform mat4 Proj, View, ViewInverse;

uniform vec3 EyePos;

uniform float OcclusionRadius;

uniform vec3 Pos;
uniform float Rad;

void main()
{
	vec2 texCoord = gl_FragCoord.xy / vec2(1280, 720);
	float rad = Rad + OcclusionRadius;

	vec3 pos = texture2D(PosTex, texCoord);

	float distanceLol = distance(pos, Pos);
	if (distanceLol > rad) discard;

	vec3 normal = texture2D(NormalTex, texCoord);

	gl_FragColor = vec4(pow(1.0 - (distanceLol - Rad) / OcclusionRadius, 2.0) * smoothstep(dot(normalize(pos - Pos), normal), 1.0, .99));
}
