#version 330 core

layout(location = 0, index = 0) out vec4 out_color0;

uniform sampler2D tex;
uniform sampler2D tex_lines;
uniform vec4 color;
uniform vec4 wave_h;

in vec2 texcoord0;
in float vs_h;

float sat( float t )
{
	return clamp( t, 0, 1 );
}

void main()
{
	vec4 samplecol = texture( tex, texcoord0 );
	vec4 samplecol_lines = texture( tex_lines, texcoord0 );

	float t = 1.0f-sat( pow( abs(vs_h - wave_h.x)/10.0f, 0.5f) );

	t+= 0.0125f;

	out_color0 = samplecol * color + t * (0.85f + samplecol_lines );
}
