#version 330 core

layout(location = 0, index = 0) out vec4 outcol;

uniform sampler2D tex0;
uniform vec4 time;
uniform vec4 parms;
uniform vec4 parms2;

in vec2 texcoord0;

const vec3 up = vec3(0,1,0);
const float near_clip = 10.0f;
const float farclip = 250.0f;
const float term_dist = 0.01f;

const vec2 aspect = vec2( 16.0f/9.0f, 1.0f );//TODO: input

//note: THIS is correct!
vec3 spherical_uv( vec3 v ) {
	float rad = length( v );
	float theta = atan( v.y, v.x );
	float phi = acos( v.z / rad );
	return vec3( rad, theta, phi );
}

//note: this is wro0ong...!
vec3 spherical( vec3 v ) {
	float rad = length( v );
	float theta = atan( v.y / v.x ); // doesn't check quadrant...
	float phi = acos( v.z / rad );
	return vec3( rad, theta, phi );
}

float d1( vec3 p, vec3 o, float r ) {
	float m = parms.x;
	vec3 v = p-o;
	vec3 sph = spherical( v );
	float dphi = 10.0f * sph.y;
	float a = m * 0.1f * clamp( 1.0f-0.75f*abs(sph.z-1.5f), 0.0f, 1.0f );
	float dv = 1.0f + a * sin ( dphi + 4 * time.x );
	return length( v * dv ) - r;
}

float d2( vec3 p, vec3 o, float r ) {
	float m = parms.x;
	vec3 v = p-o;
	vec3 sph = spherical( vec3(v.x, -v.z, v.y) );
	float dphi = 10 * sph.y;
	float a = m * 0.1f * clamp( 1-0.75f*abs(sph.z-1.5f), 0.0f, 1.0f );
	float dv = 1.0f + a * sin ( dphi + 4 * time.x);
	return length( v * dv ) - r;
}

const float PI = 3.1415926536f;

vec4 distort_sphere3( vec3 p, vec3 o, float r ) {
	vec3 v = p-o;
	float da = d1( p, o, r );
	float db = d2( p, o, r );
	float dist = mix( da, db, 0.5f );

	vec2 uv = spherical_uv( vec3(v.x,v.z,-v.y)).yz * vec2( -0.5f/PI, 1.0f/PI ) + vec2( 0.5, 0.0f );
	const float matid = 0;
	return vec4( dist, uv, matid );
}

vec4 distort_sphere1( vec3 p, vec3 o, float r ) {
	float m = parms.x;
	vec3 v = p-o;
	float dp = dot( v, up );

	float t0 = 1.0f;
	float t1 = 1.0f;

	float dr = 1.0f; // + 0.15f * sin( 2*dp + time.x );
	float dv = 1.0f;
	dv = mix( dv, dv - m * 0.1f * sin(v.y) * sin(v.x + 1.3f*time.x) * sin(v.z + time.x), t0 );
	dv = mix( dv, dv - m * 0.03f * sin(3*dp + 5*time.x), t1 );

	float dist = length( v * dv ) - r * dr;
	vec2 uv = spherical_uv(vec3(v.x,v.z,-v.y)).yz * vec2( -0.5f/PI, 1.0f/PI ) + vec2( 0.5, 0.0f );
	const float matid = 0;
	return vec4( dist, uv, matid );
}

// note: xyz-distort
vec4 distort_sphere2( vec3 p, vec3 o, float r ) {
	float m = parms.x;
	vec3 v = p-o;

	float d = length( v ) -r;
	vec3 dist = m * 0.25f * sin( 3 * p + 3 * time.x );

	float t = d + dist.x + dist.y + dist.z;

	vec2 uv = spherical_uv(vec3(v.x,v.z,-v.y)).yz * vec2( -0.5f/PI, 1.0f/PI ) + vec2( 0.5, 0.0f );
	const float matid = 0;
	return vec4( t, uv, matid );
}


//honestly stolen from http://iquilezles.org/www/articles/distfunctions/distfunctions.htm
vec4 udRoundBox( vec3 p, vec3 b, float r )
{
	float dist = length(max(abs(p)-b,0.0))-r;
	vec2 uv = vec2(0.0f);
	const float matid = 1;
	return vec4( dist, uv, matid );
}
vec4 sdBox( vec3 p, vec3 b ) {
	vec3  di = abs(p) - b;
	float mc = max( di.x, max(di.y, di.z) );
	float dist = min(mc, length(max(di,0.0)));
	vec2 uv = vec2( 0.0f ); //TODO
	const float matid = 1;
	return vec4( dist, uv, matid );
}
float spheredist( vec3 p, vec3 o, float r ) {
	vec3 v = p-o;
	return length( v ) - r;
}
vec4 planedist( vec3 p, vec3 point, vec3 norm ) {
	float dist = dot( norm, p-point );
	vec2 uv = vec2( 0, 0 ); //TODO
	float matid = 3;
	return vec4( dist, uv, matid );
}

vec4 select( vec4 a, vec4 b ) {
	return (a.x<b.x) ? a : b;
}

vec4 select_max( vec4 a, vec4 b ) {
	return (a.x>b.x) ? a : b;
}

vec4 scene_lptlogo( vec3 p ) {
	const vec3 box0_pos = vec3( 0, 5, -4 );
	const vec3 box1_pos = vec3( 0, 5, -1 );
	const vec3 box2_pos = vec3( 0, 5,  2 );
	const vec3 box4_pos = vec3( 0, 2,  2 );
	const vec3 box3_pos = vec3( 0, 2, -1 );
	const vec3 box5_pos = vec3( 0, -1, 2 );

	const vec3 box_siz = vec3( 1, 1, 1 );
	const float box_rad = 0.25f;

	vec4 d = vec4( 100000.0f, 0, 0, 0 );
	d = select( d, udRoundBox( p-box0_pos, box_siz, box_rad ) );
	d = select( d, udRoundBox( p-box1_pos, box_siz, box_rad ) );
	d = select( d, udRoundBox( p-box2_pos, box_siz, box_rad ) );

	d = select( d, udRoundBox( p-box3_pos, box_siz, box_rad ) );
	d = select( d, udRoundBox( p-box4_pos, box_siz, box_rad ) );

	d = select( d, udRoundBox( p-box5_pos, box_siz, box_rad ) );

	//TODO, better distortion
	vec3 dist = vec3(0, 0, 0.2f * sin( 2 * p.z*p.y + 3 + 15*time.x ) );
	dist += vec3( 0, 0.25f*sin( 2*p.z + time.x ), 0 );
	dist = mix( vec3(0.0f), dist, parms.w );

	return d + dist.x + dist.y + dist.z;
}

vec4 scene_sphere( vec3 p ) {
	const vec3 sphere_ctr = vec3( 0, 3, 0 );
	const float sphere_rad = 4;

	vec4 d = vec4( farclip, 0.0f, 0.0f, -1.0f ); //note: background
	d = select( d, distort_sphere3(p, sphere_ctr, sphere_rad) );

	return d;
}

vec4 scene_slice_sphere( vec3 p ) {
	const vec3 sphere_ctr = vec3( 0, 3, 0 );
	const float sphere_rad = 4;

	//TODO: rotation... and more cuts
	//TODO: and half cuts
	vec3 slice_pos = vec3( 0, 2, 0 );
	const vec3 slice_size = vec3( 10, 1, 10 );

	vec4 box_dist = sdBox( p - slice_pos, slice_size );
	vec3 slice_offset = vec3(0, 0, parms2.x);

	vec4 d1 = vec4( farclip, 0.0f, 0.0f, -1.0f ); //note: background
	d1 = select( d1, distort_sphere3(p, sphere_ctr+slice_offset, sphere_rad) );
	//note: slice of sphere
	d1 = select_max( d1, box_dist );

	vec4 d2 = vec4( farclip, 0.0f, 0.0f, -1.0f ); //note: background
	d2 = select( d2, distort_sphere3(p, sphere_ctr, sphere_rad) );
	//note: everything around slice
	d2 = select_max( d2, -box_dist );

	vec4 d3 = select( d1, d2 );

	return d3;
}

// ====
vec4 scene_sphere_tremors( vec3 p ) {
	//TODO: "impact"-like hits, with circular tremor-waves going all around the sphere
	//      many of them with small size should make it look cool...  + color?
	return vec4( farclip, 0, 0, -1 );
}

// ====
vec2 rot2d( vec2 p, float a )
{
	vec2 sc = vec2(sin(a),cos(a));
	vec2 ret;
	ret.x = dot( p, sc.yx*vec2(1,-1) );
	ret.y = dot( p, sc.xy );
	return ret;
}

vec3 mirror( vec3 p, vec3 pn_ctr, vec3 pn_norm )
{
	vec3 v0 = p-pn_ctr; 
	float dp0 = dot( v0, pn_norm );
	if ( dp0 > 0 )
		return p;
	return p - 2 * dp0 * pn_norm;
}

// ====
vec4 scene_inf( vec3 p ) {
	const vec3 sphere_ctr = vec3( 5, 3, 5 );
	const float sphere_rad = 3.5;

	const vec3 plane_ctr = vec3( 0, 0, 0 );
	const vec3 plane_norm = vec3( 0, 1, 0 );

	vec2 uv = vec2( 0.0f, 0.0f );
	float matid = 2;
	vec4 d = vec4( farclip, 0.0f, 0.0f, -1.0f ); //note: background

	p = mirror( p, vec3(0), vec3(0,0,1) );
	p = mirror( p, vec3(0), vec3(1,0,0) );

	float l = 0.005*length( p.xz );
	vec3 p_mod;
	p_mod.xz = rot2d( p.xz, l );
	p_mod.y = p.y;
	p_mod = mod(p_mod,10);
	d = select( d, vec4( spheredist( vec3(p_mod.x,p.y,p_mod.z), sphere_ctr, sphere_rad), uv, matid ) );
	d = select( d, planedist(p, plane_ctr, plane_norm) );

	return d;
}

//TODO: scene with noise, and only specular

void init0( out vec3 cam_eye, out vec3 cam_lookat, out vec3 cam_up )
{
	cam_eye    = vec3( 15, 6, 5*sin(time.x) ); //front
	cam_lookat = vec3( 0, 3, 0 );
	cam_up     = normalize( vec3( 0.2, 1, 0 ) );
}
vec4 scene0( vec3 p ) {
	return scene_slice_sphere( p );
}

void init1( out vec3 cam_eye, out vec3 cam_lookat, out vec3 cam_up ) {
	cam_eye    = vec3( 15*cos(0.2*time.x), 30, 17*sin(0.2*time.x) );
	cam_lookat = vec3( 0, 25, 0 );
	cam_up     = normalize( vec3( 0.2, 1, 0 ) );
}
vec4 scene1( vec3 p ) {
	return scene_inf( p );
}

void init2( out vec3 cam_eye, out vec3 cam_lookat, out vec3 cam_up ) {
	cam_eye    = vec3( 15*cos(0.2*time.x), 30, 17*sin(0.2*time.x) );
	cam_lookat = vec3( 0, 25, 0 );
	cam_up     = normalize( vec3( 0.2, 1, 0 ) );
}
vec4 scene2( vec3 p ) {
	vec4 d0 = scene_sphere( p );
	vec4 d2 = scene_lptlogo( p );
	float morph = parms.y;
	vec4 d = mix( d0, d2, morph );

	//DBG, for ref
	//d = select( d, udRoundBox( p-vec3(0,0,10), vec3(1,1,1), 0.25f ) );
	//d = select( d, udRoundBox( p-vec3(0,0,-10), vec3(1,1,1), 0.25f ) );

	return d;
}

// ====
void init3( out vec3 cam_eye, out vec3 cam_lookat, out vec3 cam_up ) {
	cam_eye    = vec3( 19, 8, -5+1*sin(time.x) ); //front
	//cam_eye    = vec3( 7, -2, -8 ); //TODO: move nearplane
	cam_lookat = vec3( 0, 0, 0 );
	cam_up     = normalize( vec3( 0.5, 1, 0 ) );
}
vec4 scene3( vec3 p ) {
	vec2 uv = vec2( 0.0f, 0.0f );
	float matid = 2;
	vec4 d = vec4( farclip, 0.0f, 0.0f, -1.0f ); //note: background
	vec3 box_ctr = vec3(0,0,0);
	vec3 box_dim = vec3( 1, 1, 30 );
	p = mirror( p, vec3(0,1,0), normalize(vec3(0,1,0)) );
	//p = mirror( p, vec3(0,0,0), normalize(vec3(1,0,0)) );
	vec3 loc_p = p-box_ctr;
	float t = 1;
	t *= 0.7 * (sin( 0.1*p.z + 0.5*parms.x ));
	t += 0.15 * sin( 4*sin(p.z)+ time.x );
	loc_p = loc_p * (1-t);
	loc_p.xy = rot2d( loc_p.xy, 0.2*p.z + (2*time.x )+sin(time.x) );
	d = select( d, sdBox( loc_p, box_dim ) );
	d.w = 2;

	return d;
}


// ===
void init( out vec3 cam_eye, out vec3 cam_lookat, out vec3 cam_up )
{
#if defined( SCENE00 )
	init0( cam_eye, cam_lookat, cam_up );
#endif
#if defined( SCENE01 )
	init1( cam_eye, cam_lookat, cam_up );
#endif
#if defined( SCENE02 )
	init2( cam_eye, cam_lookat, cam_up );
#endif
#if defined( SCENE03 )
	init3( cam_eye, cam_lookat, cam_up );
#endif
}

// ====
vec4 scene( vec3 p )
{
#if defined( SCENE00 )
	return scene0( p );
#endif
#if defined( SCENE01 )
	return scene1( p );
#endif
#if defined( SCENE02 )
	return scene2( p );
#endif
#if defined( SCENE03 )
	return scene3( p );
#endif
}

// ====
vec3 grad( vec3 p, float d )
{
	const vec3 eps = vec3( 10*term_dist, 0, 0 );
	return normalize( vec3( scene( p + eps.xyz ).x - d,
							scene( p + eps.zxy ).x - d,
							scene( p + eps.yzx ).x - d ) );
}

float fakeao( vec3 p ) {
	const vec3 sphere_ctr = vec3( 0, 3, 0 );
	const float sphere_rad = 4;
	float l = length( sphere_ctr - p ) / 5;
	return smoothstep( 0, 1, pow( l, 2) );
}

float ao( vec3 p, vec3 n, float max_dist ) {
	const int num_samples = 5;
	const float num_samples_f = float(num_samples);
	float stepsiz = max_dist / num_samples_f;
	const float falloff = 3.0f;

	float d = 1.0f;
	for ( int i=1; i<num_samples; i++ )
	{
		float t = float(i) / num_samples_f;
		float s = t * max_dist;
		float val = scene( p + s * n ).x - s;
		d *= 1.0f - val / pow( falloff, float(i) );
	}

	return clamp( d, 0, 1 );
}

float topReflect( vec3 norm, vec3 dir )
{
	float v = step( norm.x, norm.y ) * step( norm.z, norm.y );
	const float falloff = 4;
	const float intensity = 3;
	float fresnel = pow( 1 - dot( norm, -dir ), falloff ); //TODO: schlick
	return (0.15+v) * fresnel * intensity;
	return 0;
}

vec3 get_material_col( vec4 d ) {

	vec4 matid = d.wwww;

	vec3 mat0_col = texture( tex0, d.yz*vec2(2,1)-vec2(0.5f, 0) ).rgb;
	vec3 mat1_col = mix( vec3( 0.9f, 0.75f, 0.1f ), vec3(0.0f), clamp(parms.z,0,1) );
	//vec3 mat2_col = vec3(0.8f); //1.25f*vec3( 0.5f, 0.6f, 0.7f );
	vec3 mat2_col = vec3(0.05f);

	vec4 limits = vec4(-0.5f, 0.5f, 1.5f, 2.5f);
	vec4 matid_less = step( limits, matid );
	vec4 matid_great = step( matid, limits+1);
	vec4 matid_mask = matid_less * matid_great;

	//return mat2_col;

	return matid_mask.x * mat0_col
		 + matid_mask.y * mat1_col
		 + matid_mask.z * mat2_col;
}

//note: mostly used thingy...
//[0;1]
float rand( vec2 n ) {
	return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* 43758.5453);
}

void main()
{
	vec3 cam_eye;
	vec3 cam_lookat;
	vec3 cam_up;

	init( cam_eye, cam_lookat, cam_up );

	//wtf?
	 // cam_eye.x += 0.2*time.x;
	 // cam_lookat.x += 0.2*time.x;

	//TODO: cam-shake?

	const float farclipsq = farclip*farclip;

	vec3 negz = normalize( cam_lookat - cam_eye );
	vec3 u = cross( negz, cam_up );
	vec3 v = cross( u, negz );

	u *= texcoord0.x;
	v *= texcoord0.y;

	vec2 dim = 0.25f * aspect; //controls fov
	u *= dim.xxx;
	v *= dim.yyy;

	float dist = 0.25f; //...also controls fov :p
	vec3 dir = dist * negz + u + v;
	dir = normalize( dir );

	vec3 p = cam_eye + near_clip * dir;

	//note: jitter... something...
	// float rnd = rand( gl_FragCoord.xy );
	// float r = 1 + 0.001f * (rnd*2-1);

	int i=0;
	vec4 d;
	const int num_iterations = 256;
	float rdt = 0;
	for ( i=0; i<num_iterations; i++ )
	{
		d = scene( p );
		if ( (d.x < term_dist ) || (rdt > 0.25f*farclip) ) {
			break;
		}
		else {
			//note: 0.3f to compensate for distorted space, actual dist < dist - could use gradient-approximation instead? (see iq)
			//note: max to limit min-step
			float dt = max( 2*term_dist, d.x * 0.4f ); //note: best value for eqish
			p += dir * dt;
			rdt += dt;
		}
	}

	vec3 norm = grad( p, d.x );
	outcol = vec4( 0.5+0.5*norm, step(d.x, term_dist) );

	float o = ao( p, norm, 3 );
	//float o = fakeao( p );
	float dp = dot( norm, -dir ); //headlight

	vec3 matcol = get_material_col( d );

	outcol = vec4( 0,0,0,1 );
	outcol.rgb += vec3( 0.3f * o ) * matcol; //ambient
	outcol.rgb += dp * matcol; //diffuse
	//vec3 fogcol = vec3(0);
	//outcol.rgb = mix( outcol.rgb, fogcol, length(p.xyz-cam_eye.xyz) / farclip ); //fog
	outcol.a = step( d.x, term_dist ); //note: if no fog - also set bg to fogcol

	//note: top-reflection
	outcol.rgb += vec3( topReflect( norm, dir ) );

//DEBUG
//outcol.rgb = vec3( 0.01*p ); //pos
//outcol.rgb = vec3( d.yz, 0 ); //uv
//outcol.rgb = vec3( ao( p, norm, 3 ) ); //ao
//outcol.rgb = vec3( fakeao( p ) ); //ao
//outcol.rgb = 0.5f * norm + 0.5f; //norm
//outcol = vec4( dir*0.5f+0.5f, 1 );
//outcol.rgb = vec3(dot(norm,-dir)); //headlight

	outcol.rgb *= outcol.a;
	outcol.rgb = max( vec3(0), outcol.rgb );

	//HACK to brighten up background
	//outcol.rgb += (1-outcol.a)*0.3;

	float rnd = rand( gl_FragCoord.xy + 0.01f * time.x );

	//note: iteration-glow
	float it_f = float(i) - rnd + 0.5f;
	float iterations = it_f / float(num_iterations);
//outcol.rgb = vec3( iterations * (1-outcol.a) );
//outcol.a = 1;
//return;

	//note: glow
	float glowits = 0.4 * parms2.y * iterations * (1.0f-outcol.a);

	vec3 glowcol = mix( vec3( 0.5f, 0.25f, 0.85f ), vec3(1), clamp( -parms2.y/40, 0, 1 ) );

	outcol.rgb -= glowits * glowcol;
	outcol.a = outcol.a < 0.5f ? outcol.a + parms2.y * pow(iterations,1) : outcol.a;
}
