#version 330 core

layout(location = 0, index = 0) out vec4 outcol;

uniform sampler2D tex;
uniform sampler2D tex_blurred;
uniform vec4 opasity;

in vec2 texcoord_nm;

void main()
{
	vec4 sample_col = texture( tex, texcoord_nm );
	vec4 sample_col_blurred = texture( tex_blurred, texcoord_nm );

	vec3 diff = sample_col.rgb - sample_col_blurred.rgb;

	//unsharp mask
	//outcol.rgb = sample_col.rgb + opasity.xxx * diff;

	//screen glowy
	outcol.rgb = max( sample_col.rgb, sample_col.rgb + opasity.xxx * diff );

	outcol.a = sample_col.a;
}
