#version 330 core

layout(location = 0, index = 0) out vec4 outcol0;

uniform sampler2D tex0;
uniform vec4 tex0siz; //xy=size in pixels, zw = 1/xy
uniform vec4 time_s;

uniform vec4 dist;
uniform vec4 multiplier;

in vec2 texcoord0_nm;

//note: [0;1]
float rand( vec2 n ) {
  return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* 43758.5453);
}

void main()
{
	const vec2 blur_center = vec2(0.5);
	const float num_samples = 75;
	const float propagation = 1.2f;
	//const float multiplier = 1;

	float dist_nm = dist.x * tex0siz.z;

	vec2 vc = blur_center - texcoord0_nm;
	float len = length(vc);
	float c = min(len, dist_nm) / num_samples;
	
	float rnd = rand( texcoord0_nm + time_s.x );
	c += 40 * tex0siz.z * (3+len) * rnd / num_samples;
	vc = c * vc/len;
	vc *= 1.5f; //wtf

	vec4 s0 = texture( tex0, texcoord0_nm + 1*vc );
	float alpha = s0.a; //note: premult-alpha, so doesn't hide anything but org image (the rest is additive)

// outcol0 = vec4( 1000 * c, 0, 0, 1 );
// return;

	float its = 1.0f;
	vec4 sum = its * s0;
	for(int i=2; i<=num_samples; i++)
	{
		float fi = float(i);
		its = pow(1.0f/fi, propagation);
		sum.rgb += its * texture( tex0, texcoord0_nm + 0.5*fi*vc ).rgb;
	}

	outcol0 = vec4(sum.rgb * multiplier.x, alpha);

	//DEBUG
	//colOut = vec4( IN.texcoords.xy / 1280.0f, 0, 1 );
	//colOut = vec4( 1, 0, 0, 1 );
	//colOut = vec4( sum.rgb, 1 );
	//colOut = vec4( float3(alpha), 1 );
}
