#version 330 core

layout(location = 0, index = 0) out vec4 outcol0;

uniform sampler2D tex0;
uniform vec4 aspect;
uniform vec4 tex0siz; //xy=size in pixels, zw = 1/xy

in vec2 texcoord_nm;

// vec3 sat( vec3 v ) {
	// return clamp( v, 0.0f, 1.0f );
// }

float sat( float t ) {
	return clamp( t, 0.0f, 1.0f );
}

//remaps inteval [a;b] to [0;1]
float remap( float t, float a, float b ) {
	return sat( (t - a) / (b - a) );
}

//note: /\ t=[0;0.5;1], y=[0;1;0]
float linterp( float t ) {
	return sat( 1 - abs( 2*t - 1 ) );
}

vec3 spectrum_offset( float t ) {
	//TODO: just calc middle, then subtract from two ends
	//t = remap( t, 1.0f/12.0, 11.0f/12.0);
	//t = remap( t, 1.0f/6.0, 5.0f/6.0);
	vec3 ret;
	//ret.r = 1.0f - remap( t, 1.0f/6.0f, 0.5f );
	//ret.g = linterp( remap( t, 1.0f/6.0f, 5.0f/6.0f ) );
	//ret.b = remap( t, 0.5f, 5.0f/6.0f );

//TODO: input option to swap rgb?	
	float lo = step(t,0.5f);
	float hi = 1.0f-lo;
	float w = linterp( remap( t, 1.0f/6.0f, 5.0f/6.0f ) );
	float neg_w = 1.0f-w;
	ret = vec3(lo,1.0f,hi) * vec3(neg_w, w, neg_w);

	return pow( ret, vec3(1.0f/2.2f) );
}

//note: [0;1]
float rand( vec2 n ) {
  return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* 43758.5453);
}

//note: [-1;1]
float srand( vec2 n ) {
	return rand(n) * 2 - 1;
}

void main()
{
	vec2 ctr = vec2( 0.5f, 0.5f );
	vec2 ctrvec = ctr - texcoord_nm;
	ctrvec *= vec2( aspect.x, 1.0f );
	float ctrveclen = length( ctrvec );
	const float ctr_falloff = 1.35f;
	float dist_nm = pow( ctrveclen, ctr_falloff ); //TODO: input

	ctrvec = normalize( ctrvec );
	//ctrvec *= 1.0f + 0.06125f * srand( gl_FragCoord.xy );

	vec4 sample_col = vec4( 0.0f );

	const float max_dist720 = 25.0f; //TODO: input
	float maxdist_px = max_dist720 * dist_nm; //TODO: should be relative to 720p?

	const int max_num_samples = 16;
	int num_samples = int( max( 3, min( max_num_samples, 1.5*max_num_samples * ctrveclen))); //TODO reduce near center?

	float inv_num_samples = 1.0f / float(num_samples-1.0f);

	float t = 0.0f;
	float s = inv_num_samples;
	vec3 spectrum_sum = vec3( 0.0f );
	for( int i=0; i<num_samples; ++i )
	{
		vec3 spectrum_col = spectrum_offset( t );
		spectrum_sum += spectrum_col;
		float t0 = t - 0.5f;
		vec2 uv_nm = texcoord_nm + t0 * ctrvec * maxdist_px * tex0siz.zw;
		vec4 sample = texture( tex0, uv_nm );
		sample_col += sample * vec4(spectrum_col,1);
		t += s;
	}
	sample_col.rgb = sample_col.rgb / spectrum_sum.rgb;
	sample_col.a /= num_samples;

	outcol0 = sample_col;
}
