#version 330 core

layout(location = 0, index = 0) out vec4 out_color0;

uniform samplerCube cubetex;
uniform vec4 resolution;
//uniform mat4 ws_to_vs;
uniform mat4 vs_to_ws;

// ====
vec3 cubeToCylinder( vec2 uv )
{
	const float aspect = 16.0f / 9.0f;
	const float pi = 3.1415926536f;

	const float fov_y = 160;
	float vt_angle = fov_y * pi / 180.0f;
	float hz_angle = aspect * vt_angle;

	//note: dbg, everything
	//vt_angle = pi;
	//hz_angle = 2*pi;

	uv -= 0.5f;

	float theta = 0.5f * pi + vt_angle * uv.y;
	float phi = -pi + hz_angle * uv.x;

	vec3 dir = vec3( sin(theta)*cos(phi),
					 -cos(theta),
					 sin(theta)*sin(phi)
					);

	return dir;
}


void main()
{
	vec2 uv = gl_FragCoord.xy * resolution.zw;

	vec3 dir = cubeToCylinder( uv );
	//TODO: warp from one to the other?

	vec4 cubemap_sample = texture( cubetex, dir );

	out_color0 = vec4( cubemap_sample );
}
