float atan2(float x, float y )
{
	return atan( x, y );
}

vec3 rgb2hsl( const vec3 in_rgb )
{
	float u = (2.0f*in_rgb.r - in_rgb.g - in_rgb.b)    / 3.0f;
	float v = ( -in_rgb.r + 2.0f* in_rgb.g - in_rgb.b) / 3.0f;

	vec3 out_hsl;
	out_hsl.x = (abs(u) > 0) ? atan2(u,v) : 0;
	out_hsl.y = sqrt(u*u + v*v);
	out_hsl.z = dot( vec3(0.333f), in_rgb);

	return out_hsl;
}

vec3 hsl2rgb( vec3 in_hsl )
{
	float u = in_hsl.y * sin(in_hsl.x);
	float v = in_hsl.y * cos(in_hsl.x);

	vec3 out_rgb;
	out_rgb.r = in_hsl.z + u;
	out_rgb.g = in_hsl.z + v;
	out_rgb.b = sat( in_hsl.z - u - v );

	return out_rgb;
}
