#version 330 core

layout(location = 0, index = 0) out vec4 out_color0;

uniform sampler2DShadow shadowmap_tex;

uniform vec4 diffcol;

in vec2 texcoord0;
in vec3 ws_norm;
in vec3 ws_lightvec;

in vec4 cs_pos;
in vec4 ls_pos;

float sampleShadowmap( sampler2DShadow in_shadowmap_tex, vec3 ss_pos )
{
	// const float eps = 0.0001f; //TODO: move to shadow-fill pass
	const float eps = 0.0001f; //TODO: move to shadow-fill pass

	//PCF
	return texture( in_shadowmap_tex, ss_pos.xyz + vec3(0,0,eps) );

	//manual
	// float shadow_depth = texture( in_shadowmap_tex, ss_pos.xy ).r;
	// float shadowfact = step( ss_pos.z+eps, shadow_depth );
	// return shadowfact;
}

float sat( float v ) {
	return clamp( v, 0, 1 );
}

float calc_lightfalloff( vec3 in_ss_pos )
{
	float light_falloff = 1.0f - sat( 2*length( in_ss_pos.xy-vec2(0.5f) ) );
	light_falloff = sat( 8*light_falloff );
	return light_falloff * light_falloff;
}

//note: [0;1]
float nrand( vec2 n ) {
  return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* 43758.5453);
}

vec2 rot2d( vec2 p, float a ) {
	vec2 sc = vec2(sin(a),cos(a));
	return vec2( dot( p, sc.yx*vec2(1,-1) ),
				 dot( p, sc.xy ) );
}

void main()
{
	vec3 ss_pos = 0.5f + 0.5f * (ls_pos.xyz / ls_pos.w);

	//TODO: input
	vec4 resolution = vec4( 512, 512, 1.0f / 1024.0f, 1.0f / 1024.0f );

	float siz = 1.25f;
	vec4 ofs01 = vec4( 1, 1, -1, 1 ) * siz * resolution.zwzw;
	vec4 ofs23 = vec4( -1, -1, 1, -1 ) * siz * resolution.zwzw;

	float rnd = nrand( gl_FragCoord.xy );
	ofs01.xy = rot2d( ofs01.xy, rnd );
	ofs01.zw = rot2d( ofs01.zw, rnd );
	ofs23.xy = rot2d( ofs23.xy, rnd );
	ofs23.zw = rot2d( ofs23.zw, rnd );

	float shadowfact = 0.0f;
	shadowfact += 0.25f * sampleShadowmap( shadowmap_tex, ss_pos + vec3(ofs01.xy, 0) );
	shadowfact += 0.25f * sampleShadowmap( shadowmap_tex, ss_pos + vec3(ofs01.zw, 0) );
	shadowfact += 0.25f * sampleShadowmap( shadowmap_tex, ss_pos + vec3(ofs23.xy, 0) );
	shadowfact += 0.25f * sampleShadowmap( shadowmap_tex, ss_pos + vec3(ofs23.zw, 0) );

	float n_dot_l = dot( normalize(ws_norm), normalize(ws_lightvec) );
	float light_falloff = calc_lightfalloff( ss_pos );

	//note: debug, bounding rectangle
	// vec2 stepvec = step( abs(ss_pos.xy-vec2(0.5f)), vec2(0.5f) );
	// float light_falloff = stepvec.x * stepvec.y;

	//TODO: fade in shadow with last bit of n_dot_l ?
	float diffuse = n_dot_l * mix( 0.1, 1.0, shadowfact * light_falloff );
	//float diffuse = n_dot_l * shadowfact * light_falloff;

	out_color0 = vec4( diffcol.rgb * diffuse, 1 );
}
