#version 330 core

layout(location = 0, index = 0) out vec4 outcol0;

uniform vec4 diffcol;

in vec3 ws_norm;
in vec3 ws_lightvec;

void main()
{
	float len = length( ws_lightvec );

	float n_dot_l = dot( normalize(ws_norm), ws_lightvec/len );
	float falloff = 1.0f / pow(len, 1.4f);
	float diff = 40 * n_dot_l * falloff;

	outcol0 = vec4( diffcol.rgb * vec3(diff), diffcol.a );
}
