#version 130

in  vec3 in_position;
in  vec3 in_color;
in  vec2 in_status;

out vec4 color;
uniform float musictime;
uniform int event;

void main(void) {

  vec4 Position;
  float time = mod(musictime, (in_status.x+in_status.y));
  
  if (time > in_status.x) {
    color = vec4(0.0);
    Position = vec4(0.0, 0.0, 0.0, 1.0);
  } else {
    color = vec4(in_color, 1.0);
    Position = vec4(in_position * (time / in_status.x), 1.0);
    if (event == 5) Position += Position * vec4(2.0, 2.0, 2.0, 0.0);
  }

  gl_FrontColor = color;
  gl_Position = gl_ProjectionMatrix * gl_ModelViewMatrix * Position;

}