#version 130

in  vec3 in_position;
in  vec3 in_normal;
in  vec2 in_texcoords;

out vec3 normal, lightDir, eyeVec;
out vec2 tex;
uniform float musictime;
uniform float musicdata[256];
uniform int event;

void main(void) {

	normal = gl_NormalMatrix * in_normal;
	tex = in_texcoords;
	
	// Lightcalc
	vec3 vVertex = vec3(gl_ModelViewMatrix * vec4(in_position.xyz, 1.0));
	lightDir = vec3(gl_LightSource[0].position.xyz - vVertex);
	eyeVec = -vVertex;

	gl_FrontColor = vec4(1.0);	
    // Sinus Deform
    if (event == 2) {
	  float time = sin(0.7 * musictime);
      float PI = 3.14159265358979323846264;
	  float muzak = 2.0 - 2.0 * cos(0.01745329251994329576923690768489 * musictime * 14.285714285);
	  float mult = sin((3.5+in_position.x+time) * PI * muzak) * sin((1.5f+in_position.y+time) * PI * muzak) * sin((2.2f+in_position.z+time) * PI * muzak );
	  gl_Position = gl_ProjectionMatrix * gl_ModelViewMatrix * vec4(in_position.xyz+in_position.xyz*mult, 1.0);
	}
	
	// Waves
	else if (event == 4) gl_Position = gl_ProjectionMatrix * gl_ModelViewMatrix * vec4(in_position.x, in_position.y+5.0*(musicdata[0]+musicdata[1]+musicdata[2]+musicdata[3])*sin(0.1*sqrt(dot(in_position.xz, in_position.xz))+musictime*5), in_position.z, 1.0);
	else if (event == 7) gl_Position = gl_ProjectionMatrix * gl_ModelViewMatrix * vec4(in_position.x, in_position.y+3.0*sin(0.1*sqrt(dot(in_position.xz, in_position.xz))+musictime*5), in_position.z, 1.0);
   
   else if (event == 5) {
     int index = int(abs(in_position.z))%256;
     vec3 pos = in_position;
     pos.y += 50*(musicdata[index]-0.5);
     gl_Position = gl_ProjectionMatrix * gl_ModelViewMatrix * vec4(pos.x, pos.y, pos.z, 1.0);
   } 
	
	
	else gl_Position = gl_ProjectionMatrix * gl_ModelViewMatrix * vec4(in_position.xyz, 1.0);
}