#version 130

layout(points) in;
layout(triangle_strip, max_vertices=14) out;


vec4 getVertex(int num) {
  vec4 pos;
  pos.x = (((num)   & 0x1) - 0.5);
  pos.y = (((num>>1)& 0x1) - 0.5);
  pos.z = (((num>>2)& 0x1) - 0.5);
  pos.w = 1.0;
  return pos;
}


void main() {
 
   int i, j;
   int order[] = {2,1,4,3,7,1,5,2,6,4,8,7,6,5};
   
   for (i = 0; i < gl_VerticesIn; i++) {
     for (j = 0; j < 14; j++) {
       gl_Position = gl_ProjectionMatrix * gl_ModelViewMatrix * (getVertex(order[j]) + gl_PositionIn[i]);
       EmitVertex();
     }
   }
   EndPrimitive();
   
}

