#version 330

in vec2 TexCoord;

layout( location = 0 ) out vec4 out_Color;

uniform sampler2D TexSampler;
uniform sampler2D TexSampler2;

uniform float Fade;


void main()
{
	vec4 original = texture2D( TexSampler, TexCoord );
	vec4 blurred = texture2D( TexSampler2, TexCoord );

	vec4 color = original + ( blurred * 0.6 );

	vec2 imgTexCoord = TexCoord - 0.5f;

	float vignette = 1 - dot( imgTexCoord, imgTexCoord );

	color *= pow( vignette, 4 );

	color *= 2.0; //Exposure level

	out_Color = color * Fade;//pow( color, vec4( 0.55 ) ); //Gamma
}