#version 330

in vec2 TexCoord;

layout( location = 0 ) out vec4 out_Color;

uniform sampler2D TexSampler;
float TexelSize = 1.0 / 512;
float Weights[9] = float[9]( 0.2, 0.4, 0.7, 0.9, 1.0, 0.9, 0.7, 0.4, 0.2 );

void main()
{
	vec4 color = vec4( 0.0, 0.0, 0.0, 0.0 );
	float sum = 0.0;
	for( int i = 0; i < 9; i++ )
	{
		sum += Weights[i];
	}
	for( int i = -4; i <= 4; i++ )
	{
		color += ( texture2D( TexSampler, TexCoord + vec2( ( TexelSize * i ), 0.0 ) ) ) * Weights[i+4];
	}
	color /= sum;
	color.a = 1.0;
	out_Color = color;
}