#version 330 core

uniform float deltaTime;
uniform float decayTime;
uniform vec3  force;
uniform vec4  spheres[6];
uniform float attractForce;
uniform float floorDamping;

layout (location = 0) in vec4 POSITION;
layout (location = 1) in vec4 NORMAL;

out vec4 velocity;

void attractor(in vec4 sp, inout vec4 pos, inout vec4 vel)
{
	vec3 diff = pos.xyz - sp.xyz;
	float len = length(diff);
	float atten = 1.0 - (min(len, sp.w) / sp.w);
	vel.xyz += normalize(diff)*atten*attractForce;
}


void main()
{
	vec4 p, v;

	v.xyz = NORMAL.xyz + force;
	v.w = 1.0;

	p.xyz = POSITION.xyz + v.xyz*deltaTime;
	p.w = POSITION.w - deltaTime*decayTime;

	for (int i=0; i < 6; ++i)
	{
		attractor(spheres[i], p, v);
	}

	if ( abs(p.z) > 3.4 )
	{
		if ( p.y < (0.15 + p.w*0.04) )
		{
			p.y = 0.15 + p.w*0.04;
			v.xyz = reflect(v.xyz, vec3(0.0, 1.0, 0.0)) * floorDamping;
		}
	}
	else
	{
		if ( p.y < p.w*0.04 )
		{
			p.y = p.w*0.04;
			v.xyz = reflect(v.xyz, vec3(0.0, 1.0, 0.0)) * floorDamping;
		}
	}
	velocity = v;
	gl_Position = p;
}
