#version 330 core

uniform mat4 ModelViewMatrix;
uniform mat4 ModelViewProjectionMatrix;

layout (location = 0) in vec4 POSITION;
layout (location = 1) in vec4 NORMAL;

out vec2 pos_zw;

void main()
{
	float radius = smoothstep(POSITION.w, 0.0, 0.1);

	vec3 ec_pos = vec3( ModelViewMatrix * vec4(POSITION.xyz, 1.0) );
	gl_PointSize = radius * 64.0 / length(ec_pos);
	vec4 proj_pos = ModelViewProjectionMatrix * vec4(POSITION.xyz, 1.0);
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
