
float computeWeight(float value, float minExtent, float maxExtent)
{
	if ( value >= minExtent && value <= maxExtent )
	{
		float range = maxExtent - minExtent;

		float weight = value - minExtent;

		weight *= 1.0 / range;
		weight -= 0.5;
		weight *= 2.0;

		weight *= weight;

		weight = 1.0 - abs(weight);
		weight = clamp(weight, 0.001, 1.0);

		return weight;
	}
	else
	{
		return 0.0;
	}
}

vec4 weightedTexture(in sampler2D smp, in vec3 tpw, in vec3 uvw)
{
	vec4 temp = texture(smp, uvw.xy) * tpw.z;
	temp += texture(smp, uvw.yz) * tpw.x;
	temp += texture(smp, uvw.xz) * tpw.y;
	return temp;
}
